"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getComponentEvents = getComponentEvents;
const utils_1 = require("./utils");
function getComponentEvents(ts, program, fileName, tag) {
    const checker = program.getTypeChecker();
    const components = (0, utils_1.getVariableType)(ts, program, fileName, '__VLS_components');
    if (!components) {
        return [];
    }
    const componentType = (0, utils_1.getComponentType)(ts, program, fileName, components, tag);
    if (!componentType) {
        return [];
    }
    const result = new Set();
    // for (const sig of componentType.getCallSignatures()) {
    // 	const emitParam = sig.parameters[1];
    // 	if (emitParam) {
    // 		// TODO
    // 	}
    // }
    for (const sig of componentType.getConstructSignatures()) {
        const instanceType = sig.getReturnType();
        const emitSymbol = instanceType.getProperty('$emit');
        if (emitSymbol) {
            const emitType = checker.getTypeOfSymbolAtLocation(emitSymbol, components.node);
            for (const call of emitType.getCallSignatures()) {
                if (call.parameters.length) {
                    const eventNameParamSymbol = call.parameters[0];
                    const eventNameParamType = checker.getTypeOfSymbolAtLocation(eventNameParamSymbol, components.node);
                    if (eventNameParamType.isStringLiteral()) {
                        result.add(eventNameParamType.value);
                    }
                }
            }
        }
    }
    return [...result];
}
//# sourceMappingURL=getComponentEvents.js.map