//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_USD_IMAGING_USD_SKEL_IMAGING_BINDING_SCHEMA_H
#define PXR_USD_IMAGING_USD_SKEL_IMAGING_BINDING_SCHEMA_H

/// \file

#include "pxr/usdImaging/usdSkelImaging/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define USD_SKEL_IMAGING_BINDING_SCHEMA_TOKENS \
    (skelBinding) \
    (animationSource) \
    (skeleton) \
    (joints) \
    (blendShapes) \
    (blendShapeTargets) \
    (hasSkelRoot) \
    ((skinningMethodPrimvar, "skel:skinningMethod")) \
    ((geomBindTransformPrimvar, "skel:geomBindTransform")) \
    ((jointIndicesPrimvar, "skel:jointIndices")) \
    ((jointWeightsPrimvar, "skel:jointWeights")) \

TF_DECLARE_PUBLIC_TOKENS(UsdSkelImagingBindingSchemaTokens, USDSKELIMAGING_API,
    USD_SKEL_IMAGING_BINDING_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------

// Corresponds to UsdSkelBindingAPI.
//

class UsdSkelImagingBindingSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    UsdSkelImagingBindingSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "skelBinding" from the parent container and constructs a
    /// UsdSkelImagingBindingSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    USDSKELIMAGING_API
    static UsdSkelImagingBindingSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    /// Note that in UsdSkel, the animation comes from the animationSource on
    /// the Skeleton (which also carries the topology of the skeleton as
    /// joints). This animationSource is either authored on the Skeleton
    /// directly (and UsdSkelBindingAPI is applied) or inherited from an
    /// ancestor of Skeleton (that has UsdSkelBindingAPI applied).
    USDSKELIMAGING_API
    HdPathDataSourceHandle GetAnimationSource() const;

    USDSKELIMAGING_API
    HdPathDataSourceHandle GetSkeleton() const;

    USDSKELIMAGING_API
    HdTokenArrayDataSourceHandle GetJoints() const;

    /// This is not inherited according to the UsdSkel spec.
    USDSKELIMAGING_API
    HdTokenArrayDataSourceHandle GetBlendShapes() const;

    /// This is not inherited according to the UsdSkel spec.
    USDSKELIMAGING_API
    HdPathArrayDataSourceHandle GetBlendShapeTargets() const;

    /// Is this prim a descendant of a SkelRoot? Does not correspond to Usd
    /// attribute and is actually populated by the SkelRoot and not the
    /// SkelBinding.
    USDSKELIMAGING_API
    HdBoolDataSourceHandle GetHasSkelRoot() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    USDSKELIMAGING_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @}

    /// \name Data source locators for members
    ///
    /// The following methods return an HdDataSourceLocator (relative to the
    /// prim-level data source) where the data source for a member can be found.
    ///
    /// This is often useful for checking intersection against the
    /// HdDataSourceLocatorSet sent with HdDataSourceObserver::PrimsDirtied.
    /// @{

    /// Prim-level relative data source locator to locate animationSource.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetAnimationSourceLocator();

    /// Prim-level relative data source locator to locate skeleton.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetSkeletonLocator();

    /// Prim-level relative data source locator to locate joints.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetJointsLocator();

    /// Prim-level relative data source locator to locate blendShapes.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetBlendShapesLocator();

    /// Prim-level relative data source locator to locate blendShapeTargets.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetBlendShapeTargetsLocator();

    /// Prim-level relative data source locator to locate hasSkelRoot.
    USDSKELIMAGING_API
    static const HdDataSourceLocator &GetHasSkelRootLocator();
    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    USDSKELIMAGING_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdPathDataSourceHandle &animationSource,
        const HdPathDataSourceHandle &skeleton,
        const HdTokenArrayDataSourceHandle &joints,
        const HdTokenArrayDataSourceHandle &blendShapes,
        const HdPathArrayDataSourceHandle &blendShapeTargets,
        const HdBoolDataSourceHandle &hasSkelRoot
    );

    /// \class UsdSkelImagingBindingSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        USDSKELIMAGING_API
        Builder &SetAnimationSource(
            const HdPathDataSourceHandle &animationSource);
        USDSKELIMAGING_API
        Builder &SetSkeleton(
            const HdPathDataSourceHandle &skeleton);
        USDSKELIMAGING_API
        Builder &SetJoints(
            const HdTokenArrayDataSourceHandle &joints);
        USDSKELIMAGING_API
        Builder &SetBlendShapes(
            const HdTokenArrayDataSourceHandle &blendShapes);
        USDSKELIMAGING_API
        Builder &SetBlendShapeTargets(
            const HdPathArrayDataSourceHandle &blendShapeTargets);
        USDSKELIMAGING_API
        Builder &SetHasSkelRoot(
            const HdBoolDataSourceHandle &hasSkelRoot);

        /// Returns a container data source containing the members set thus far.
        USDSKELIMAGING_API
        HdContainerDataSourceHandle Build();

    private:
        HdPathDataSourceHandle _animationSource;
        HdPathDataSourceHandle _skeleton;
        HdTokenArrayDataSourceHandle _joints;
        HdTokenArrayDataSourceHandle _blendShapes;
        HdPathArrayDataSourceHandle _blendShapeTargets;
        HdBoolDataSourceHandle _hasSkelRoot;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif