"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const assert_1 = __importDefault(require("assert"));
const fileCollection_1 = require("../../../src/lib/documents/fileCollection");
describe('fileCollection', () => {
    describe('FileSet', () => {
        it('has (case sensitive)', () => {
            const set = new fileCollection_1.FileSet(/** useCaseSensitiveFileNames */ true);
            set.add('hi.svelte');
            assert_1.default.strictEqual(set.has('Hi.svelte'), false);
            assert_1.default.ok(set.has('hi.svelte'));
        });
        it('delete (case sensitive)', () => {
            const set = new fileCollection_1.FileSet(/** useCaseSensitiveFileNames */ true);
            set.add('hi.svelte');
            assert_1.default.strictEqual(set.delete('Hi.svelte'), false);
            assert_1.default.ok(set.delete('hi.svelte'));
        });
        it('has (case insensitive)', () => {
            const set = new fileCollection_1.FileSet(/** useCaseSensitiveFileNames */ false);
            set.add('hi.svelte');
            assert_1.default.ok(set.has('Hi.svelte'));
        });
        it('delete (case sensitive)', () => {
            const set = new fileCollection_1.FileSet(/** useCaseSensitiveFileNames */ false);
            set.add('hi.svelte');
            assert_1.default.ok(set.delete('Hi.svelte'));
        });
    });
    describe('FileMap', () => {
        it('has (case sensitive)', () => {
            const map = new fileCollection_1.FileMap(/** useCaseSensitiveFileNames */ true);
            const info = {};
            map.set('hi.svelte', info);
            assert_1.default.strictEqual(map.has('Hi.svelte'), false);
            assert_1.default.ok(map.has('hi.svelte'));
        });
        it('get (case sensitive)', () => {
            const map = new fileCollection_1.FileMap(/** useCaseSensitiveFileNames */ true);
            const info = {};
            map.set('hi.svelte', info);
            assert_1.default.strictEqual(map.get('Hi.svelte'), undefined);
            assert_1.default.strictEqual(map.get('hi.svelte'), info);
        });
        it('delete (case sensitive)', () => {
            const map = new fileCollection_1.FileMap(/** useCaseSensitiveFileNames */ true);
            const info = {};
            map.set('hi.svelte', info);
            assert_1.default.strictEqual(map.delete('Hi.svelte'), false);
            assert_1.default.ok(map.has('hi.svelte'));
        });
        it('has (case insensitive)', () => {
            const map = new fileCollection_1.FileMap(/** useCaseSensitiveFileNames */ false);
            const info = {};
            map.set('hi.svelte', info);
            assert_1.default.ok(map.has('Hi.svelte'));
        });
        it('get (case insensitive)', () => {
            const map = new fileCollection_1.FileMap(/** useCaseSensitiveFileNames */ false);
            const info = {};
            map.set('hi.svelte', info);
            assert_1.default.strictEqual(map.get('Hi.svelte'), info);
        });
        it('delete (case insensitive)', () => {
            const map = new fileCollection_1.FileMap(/** useCaseSensitiveFileNames */ false);
            const info = {};
            map.set('hi.svelte', info);
            assert_1.default.strictEqual(map.delete('Hi.svelte'), true);
        });
    });
});
//# sourceMappingURL=fileCollection.test.js.map