/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.itertools.CombinationsBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.itertools.CombinationsBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.CombinationsBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.PAbstractCombinations;
import com.oracle.graal.python.builtins.objects.itertools.PCombinations;
import com.oracle.graal.python.builtins.objects.itertools.PCombinationsWithReplacement;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedLoopConditionProfile;
import com.oracle.truffle.api.profiles.LoopConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCombinations, PythonBuiltinClassType.PCombinationsWithReplacement})
public final class CombinationsBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = CombinationsBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CombinationsBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object setState(PAbstractCombinations self, Object stateObj, @Bind Node inliningTarget, @Cached CastToJavaIntExactNode cast, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached PRaiseNode raiseNode) {
            PTuple state;
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            int n = self.getPool().length;
            if (stateObj instanceof PTuple && (state = (PTuple)stateObj).getSequenceStorage().length() == self.getR()) {
                SequenceStorage storage = state.getSequenceStorage();
                try {
                    for (int i = 0; i < self.getR(); ++i) {
                        int max;
                        int index = cast.execute(inliningTarget, getItemNode.execute(inliningTarget, storage, i));
                        if (index > (max = i + n - self.getR())) {
                            index = max;
                        }
                        if (index < 0) {
                            index = 0;
                        }
                        self.getIndices()[i] = index;
                    }
                }
                catch (CannotCastException e) {
                    throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
                }
                Object[] result = new Object[self.getR()];
                for (int i = 0; i < self.getR(); ++i) {
                    result[i] = self.getPool()[self.getIndices()[i]];
                }
                self.setLastResult(result);
                return PNone.NONE;
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_ARGS, SpecialMethodNames.T___SETSTATE__);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PAbstractCombinations self, @Bind Node inliningTarget, @Cached InlinedConditionProfile hasNoLastResultProfile, @Cached InlinedConditionProfile stoppedProfile, @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object type = getClassNode.execute(inliningTarget, self);
            if (hasNoLastResultProfile.profile(inliningTarget, self.getLastResult() == null)) {
                PTuple args = PFactory.createTuple(language, new Object[]{PFactory.createTuple(language, self.getPool()), self.getR()});
                return PFactory.createTuple(language, new Object[]{type, args});
            }
            if (stoppedProfile.profile(inliningTarget, self.isStopped())) {
                PTuple args = PFactory.createTuple(language, new Object[]{PFactory.createEmptyTuple(language), self.getR()});
                return PFactory.createTuple(language, new Object[]{type, args});
            }
            PTuple indices = PFactory.createTuple(language, PythonUtils.arrayCopyOf(self.getIndices(), self.getR()));
            PTuple args = PFactory.createTuple(language, new Object[]{PFactory.createTuple(language, self.getPool()), self.getR()});
            return PFactory.createTuple(language, new Object[]{type, args, indices});
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization(guards={"self.isStopped()"})
        static Object nextStopped(PAbstractCombinations self, @Bind Node inliningTarget) {
            throw NextNode.iteratorExhausted();
        }

        @Specialization(guards={"!self.isStopped()", "isLastResultNull(self)"})
        static Object nextNoResult(PAbstractCombinations self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached @Cached.Exclusive InlinedLoopConditionProfile loopConditionProfile) {
            Object[] result = new Object[self.getR()];
            loopConditionProfile.profileCounted(inliningTarget, (long)self.getR());
            int i = 0;
            while (loopConditionProfile.inject(inliningTarget, i < self.getR())) {
                int idx = self.getIndices()[i];
                result[i] = self.getPool()[idx];
                ++i;
            }
            self.setLastResult(result);
            return PFactory.createTuple(language, result);
        }

        @Specialization(guards={"!self.isStopped()", "!isLastResultNull(self)"})
        static Object next(PCombinations self, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedLoopConditionProfile indexLoopProfile, @Cached.Shared @Cached InlinedLoopConditionProfile resultLoopProfile) {
            return NextNode.nextInternal(inliningTarget, self, indexLoopProfile, resultLoopProfile);
        }

        @Specialization(guards={"!self.isStopped()", "!isLastResultNull(self)"})
        static Object next(PCombinationsWithReplacement self, @Bind Node inliningTarget, @Cached.Shared @Cached InlinedLoopConditionProfile indexLoopProfile, @Cached.Shared @Cached InlinedLoopConditionProfile resultLoopProfile) {
            return NextNode.nextInternal(inliningTarget, self, indexLoopProfile, resultLoopProfile);
        }

        private static Object nextInternal(Node inliningTarget, PAbstractCombinations self, InlinedLoopConditionProfile indexLoopProfile, InlinedLoopConditionProfile resultLoopProfile) {
            int i;
            CompilerAsserts.partialEvaluationConstant(self.getClass());
            Object[] result = PythonUtils.arrayCopyOf(self.getLastResult(), self.getLastResult().length);
            int poolLen = self.getPool().length;
            for (i = self.getR() - 1; i >= 0 && self.getIndices()[i] == self.getMaximum(poolLen, i); --i) {
            }
            if (i < 0) {
                self.setStopped(true);
                throw NextNode.iteratorExhausted();
            }
            int[] nArray = self.getIndices();
            int n = i;
            nArray[n] = nArray[n] + 1;
            indexLoopProfile.profileCounted(inliningTarget, (long)(self.getR() - i + 1));
            int j = i + 1;
            while (indexLoopProfile.inject(inliningTarget, j < self.getR())) {
                self.getIndices()[j] = self.maxIndex(j);
                ++j;
            }
            resultLoopProfile.profileCounted(inliningTarget, (long)(self.getR() - i));
            j = i;
            while (resultLoopProfile.inject(inliningTarget, j < self.getR())) {
                Object elem;
                int index = self.getIndices()[j];
                result[j] = elem = self.getPool()[index];
                ++j;
            }
            self.setLastResult(result);
            return PFactory.createTuple(PythonLanguage.get(inliningTarget), result);
        }

        protected boolean isLastResultNull(PAbstractCombinations self) {
            return self.getLastResult() == null;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PAbstractCombinations self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="combinations", minNumOfPositionalArgs=3, parameterNames={"cls", "iterable", "r"})
    @ArgumentClinic(name="r", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    public static abstract class CombinationsNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CombinationsBuiltinsClinicProviders.CombinationsNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object construct(VirtualFrame frame, Object cls, Object iterable, int r, @Bind Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached IteratorNodes.ToArrayNode toArrayNode, @Cached LoopConditionProfile indicesLoopProfile, @Cached InlinedConditionProfile wrongTypeProfile, @Cached InlinedConditionProfile negativeProfile, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (!wrongTypeProfile.profile(inliningTarget, isTypeNode.execute(inliningTarget, cls))) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            if (negativeProfile.profile(inliningTarget, r < 0)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.MUST_BE_NON_NEGATIVE, "r");
            }
            PCombinations self = PFactory.createCombinations(language, cls, getInstanceShape.execute(cls));
            self.setPool(toArrayNode.execute(frame, iterable));
            int[] indices = new int[r];
            indicesLoopProfile.profileCounted((long)r);
            int i = 0;
            while (indicesLoopProfile.inject(i < r)) {
                indices[i] = i;
                ++i;
            }
            self.setIndices(indices);
            self.setR(r);
            self.setLastResult(null);
            self.setStopped(r > self.getPool().length);
            return self;
        }
    }
}

