# This file has been autogenerated by the pywayland scanner

# Copyright © 2019 Christopher Billington
# Copyright © 2020 Ilia Bozhinov
# Copyright © 2022 Victoria Brekenfeld
#
# Permission to use, copy, modify, distribute, and sell this
# software and its documentation for any purpose is hereby granted
# without fee, provided that the above copyright notice appear in
# all copies and that both that copyright notice and this permission
# notice appear in supporting documentation, and that the name of
# the copyright holders not be used in advertising or publicity
# pertaining to distribution of the software without specific,
# written prior permission.  The copyright holders make no
# representations about the suitability of this software for any
# purpose.  It is provided "as is" without express or implied
# warranty.
#
# THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
# SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
# SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
# ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
# THIS SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .ext_workspace_group_handle_v1 import ExtWorkspaceGroupHandleV1


class ExtWorkspaceHandleV1(Interface):
    """A workspace handing a group of surfaces

    A :class:`ExtWorkspaceHandleV1` object represents a workspace that handles
    a group of surfaces.

    Each workspace has: - a name, conveyed to the client with the name event -
    potentially an id conveyed with the id event - a list of states, conveyed
    to the client with the state event - and optionally a set of coordinates,
    conveyed to the client with the coordinates event

    The client may request that the compositor activate or deactivate the
    workspace.

    Each workspace can belong to only a single workspace group. Depending on
    the compositor policy, there might be workspaces with the same name in
    different workspace groups, but these workspaces are still separate (e.g.
    one of them might be active while the other is not).
    """

    name = "ext_workspace_handle_v1"
    version = 1

    class state(enum.IntFlag):
        active = 1
        urgent = 2
        hidden = 4

    class workspace_capabilities(enum.IntFlag):
        activate = 1
        deactivate = 2
        remove = 4
        assign = 8


class ExtWorkspaceHandleV1Proxy(Proxy[ExtWorkspaceHandleV1]):
    interface = ExtWorkspaceHandleV1

    @ExtWorkspaceHandleV1.request()
    def destroy(self) -> None:
        """Destroy the :class:`ExtWorkspaceHandleV1` object

        Destroys the :class:`ExtWorkspaceHandleV1` object.

        This request should be made either when the client does not want to use
        the workspace object any more or after the remove event to finalize the
        destruction of the object.
        """
        self._marshal(0)
        self._destroy()

    @ExtWorkspaceHandleV1.request()
    def activate(self) -> None:
        """Activate the workspace

        Request that this workspace be activated.

        There is no guarantee the workspace will be actually activated, and
        behaviour may be compositor-dependent. For example, activating a
        workspace may or may not deactivate all other workspaces in the same
        group.
        """
        self._marshal(1)

    @ExtWorkspaceHandleV1.request()
    def deactivate(self) -> None:
        """Deactivate the workspace

        Request that this workspace be deactivated.

        There is no guarantee the workspace will be actually deactivated.
        """
        self._marshal(2)

    @ExtWorkspaceHandleV1.request(
        Argument(ArgumentType.Object, interface=ExtWorkspaceGroupHandleV1),
    )
    def assign(self, workspace_group: ExtWorkspaceGroupHandleV1) -> None:
        """Assign workspace to group

        Requests that this workspace is assigned to the given workspace group.

        There is no guarantee the workspace will be assigned.

        :param workspace_group:
        :type workspace_group:
            :class:`~pywayland.protocol.ext_workspace_v1.ExtWorkspaceGroupHandleV1`
        """
        self._marshal(3, workspace_group)

    @ExtWorkspaceHandleV1.request()
    def remove(self) -> None:
        """Remove the workspace

        Request that this workspace be removed.

        There is no guarantee the workspace will be actually removed.
        """
        self._marshal(4)


class ExtWorkspaceHandleV1Resource(Resource):
    interface = ExtWorkspaceHandleV1

    @ExtWorkspaceHandleV1.event(
        Argument(ArgumentType.String),
    )
    def id(self, id: str) -> None:
        """Workspace id

        If this event is emitted, it will be send immediately after the
        :class:`ExtWorkspaceHandleV1` is created or when an id is assigned to a
        workspace (at most once during it's lifetime).

        An id will never change during the lifetime of the
        `:class:`ExtWorkspaceHandleV1`` and is guaranteed to be unique during
        it's lifetime.

        Ids are not human-readable and shouldn't be displayed, use `name` for
        that purpose.

        Compositors are expected to only send ids for workspaces likely stable
        across multiple sessions and can be used by clients to store
        preferences for workspaces. Workspaces without ids should be considered
        temporary and any data associated with them should be deleted once the
        respective object is lost.

        :param id:
        :type id:
            `ArgumentType.String`
        """
        self._post_event(0, id)

    @ExtWorkspaceHandleV1.event(
        Argument(ArgumentType.String),
    )
    def name(self, name: str) -> None:
        """Workspace name changed

        This event is emitted immediately after the
        :class:`ExtWorkspaceHandleV1` is created and whenever the name of the
        workspace changes.

        A name is meant to be human-readable and can be displayed to a user.
        Unlike the id it is neither stable nor unique.

        :param name:
        :type name:
            `ArgumentType.String`
        """
        self._post_event(1, name)

    @ExtWorkspaceHandleV1.event(
        Argument(ArgumentType.Array),
    )
    def coordinates(self, coordinates: list) -> None:
        """Workspace coordinates changed

        This event is used to organize workspaces into an N-dimensional grid
        within a workspace group, and if supported, is emitted immediately
        after the :class:`ExtWorkspaceHandleV1` is created and whenever the
        coordinates of the workspace change. Compositors may not send this
        event if they do not conceptually arrange workspaces in this way. If
        compositors simply number workspaces, without any geometric
        interpretation, they may send 1D coordinates, which clients should not
        interpret as implying any geometry. Sending an empty array means that
        the compositor no longer orders the workspace geometrically.

        Coordinates have an arbitrary number of dimensions N with an uint32
        position along each dimension. By convention if N > 1, the first
        dimension is X, the second Y, the third Z, and so on. The compositor
        may chose to utilize these events for a more novel workspace layout
        convention, however. No guarantee is made about the grid being filled
        or bounded; there may be a workspace at coordinate 1 and another at
        coordinate 1000 and none in between. Within a workspace group, however,
        workspaces must have unique coordinates of equal dimensionality.

        :param coordinates:
        :type coordinates:
            `ArgumentType.Array`
        """
        self._post_event(2, coordinates)

    @ExtWorkspaceHandleV1.event(
        Argument(ArgumentType.Uint),
    )
    def state(self, state: int) -> None:
        """The state of the workspace changed

        This event is emitted immediately after the
        :class:`ExtWorkspaceHandleV1` is created and each time the workspace
        state changes, either because of a compositor action or because of a
        request in this protocol.

        Missing states convey the opposite meaning, e.g. an unset active bit
        means the workspace is currently inactive.

        :param state:
        :type state:
            `ArgumentType.Uint`
        """
        self._post_event(3, state)

    @ExtWorkspaceHandleV1.event(
        Argument(ArgumentType.Uint),
    )
    def capabilities(self, capabilities: int) -> None:
        """Compositor capabilities

        This event advertises the capabilities supported by the compositor. If
        a capability isn't supported, clients should hide or disable the UI
        elements that expose this functionality. For instance, if the
        compositor doesn't advertise support for removing workspaces, a button
        triggering the remove request should not be displayed.

        The compositor will ignore requests it doesn't support. For instance, a
        compositor which doesn't advertise support for remove will ignore
        remove requests.

        Compositors must send this event once after creation of an
        :class:`ExtWorkspaceHandleV1` . When the capabilities change,
        compositors must send this event again.

        :param capabilities:
            capabilities
        :type capabilities:
            `ArgumentType.Uint`
        """
        self._post_event(4, capabilities)

    @ExtWorkspaceHandleV1.event()
    def removed(self) -> None:
        """This workspace has been removed

        This event is send when the workspace associated with the
        :class:`ExtWorkspaceHandleV1` has been removed. After sending this
        request, the compositor will immediately consider the object inert. Any
        requests will be ignored except the destroy request.

        It is guaranteed there won't be any more events referencing this
        :class:`ExtWorkspaceHandleV1`.

        The compositor must only remove a workspaces not currently belonging to
        any workspace_group.
        """
        self._post_event(5)


class ExtWorkspaceHandleV1Global(Global):
    interface = ExtWorkspaceHandleV1


ExtWorkspaceHandleV1._gen_c()
ExtWorkspaceHandleV1.proxy_class = ExtWorkspaceHandleV1Proxy
ExtWorkspaceHandleV1.resource_class = ExtWorkspaceHandleV1Resource
ExtWorkspaceHandleV1.global_class = ExtWorkspaceHandleV1Global
