/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import java.util.BitSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class UnsignedBitSet
implements Cloneable {
    @NotNull
    private final BitSet myPositiveSet;
    @NotNull
    private final BitSet myNegativeSet;

    public UnsignedBitSet(@NotNull BitSet positiveSet, @NotNull BitSet negativeSet) {
        if (positiveSet == null) {
            UnsignedBitSet.$$$reportNull$$$0(0);
        }
        if (negativeSet == null) {
            UnsignedBitSet.$$$reportNull$$$0(1);
        }
        this.myPositiveSet = positiveSet;
        this.myNegativeSet = negativeSet;
    }

    public UnsignedBitSet() {
        this(new BitSet(), new BitSet());
    }

    private static int toPositive(int bitIndex) {
        return -bitIndex;
    }

    public void set(int bitIndex, boolean value) {
        if (bitIndex >= 0) {
            this.myPositiveSet.set(bitIndex, value);
        } else {
            this.myNegativeSet.set(UnsignedBitSet.toPositive(bitIndex), value);
        }
    }

    public void set(int fromIndex, int toIndex, boolean value) {
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
        if (fromIndex >= 0) {
            this.myPositiveSet.set(fromIndex, toIndex + 1, value);
        } else if (toIndex < 0) {
            this.myNegativeSet.set(UnsignedBitSet.toPositive(toIndex), UnsignedBitSet.toPositive(fromIndex) + 1, value);
        } else {
            this.myPositiveSet.set(0, toIndex + 1, value);
            this.myNegativeSet.set(UnsignedBitSet.toPositive(-1), UnsignedBitSet.toPositive(fromIndex) + 1, value);
        }
    }

    public boolean get(int bitIndex) {
        if (bitIndex >= 0) {
            return this.myPositiveSet.get(bitIndex);
        }
        return this.myNegativeSet.get(UnsignedBitSet.toPositive(bitIndex));
    }

    public UnsignedBitSet clone() {
        return new UnsignedBitSet((BitSet)this.myPositiveSet.clone(), (BitSet)this.myNegativeSet.clone());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "positiveSet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "negativeSet";
                break;
            }
        }
        objectArray[1] = "com/intellij/vcs/log/graph/utils/UnsignedBitSet";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

