/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines3;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.decoration.Rainbow;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandRepeatWhile3Multilines
extends CommandMultilines3<ActivityDiagram3> {
    private static final IRegex END = new RegexConcat(new RegexLeaf(1, "TEST1", "(.*)"), new RegexLeaf("\\)"), new RegexLeaf(";?"), RegexLeaf.end());
    private static final Pattern2 IS_OR_EQUALS = Pattern2.cmpile("\\)[%s]*(is|equals?)[%s]*\\(");

    public CommandRepeatWhile3Multilines() {
        super(CommandRepeatWhile3Multilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH, END);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandRepeatWhile3Multilines.class.getName(), RegexLeaf.start(), new RegexLeaf("repeat"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("while"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\("), new RegexLeaf(1, "TEST1", "(.*)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(ActivityDiagram3 diagram, BlocLines lines) throws NoSuchColorException {
        lines = lines.trim();
        RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst().getString()));
        RegexResult lineLast = this.getEndingPattern().matcher(lines.getLast().getString());
        String test = line0.get("TEST1", 0);
        Display testDisplay = Display.getWithNewlines(diagram.getPragma(), test);
        for (StringLocated s : lines.subExtract(1, 1)) {
            testDisplay = testDisplay.add(s.getString());
        }
        String trailTest = lineLast.get("TEST1", 0);
        if (!StringUtils.isEmpty(trailTest)) {
            testDisplay = testDisplay.add(trailTest);
        }
        Display yes = Display.NULL;
        Display out = Display.NULL;
        Rainbow linkColor = Rainbow.none();
        Display linkLabel = Display.NULL;
        List<Display> splitted = testDisplay.splitMultiline(IS_OR_EQUALS);
        if (splitted.size() == 2) {
            testDisplay = splitted.get(0);
            yes = splitted.get(1);
        }
        return diagram.repeatWhile(testDisplay, yes, out, linkLabel, linkColor, null, null);
    }
}

