/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.util.List;
import org.eclipse.elk.alg.layered.DotDebugUtil;
import org.eclipse.elk.alg.layered.JsonDebugUtil;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.p4nodes.LinearSegmentsNodePlacer;
import org.eclipse.elk.alg.layered.p5edges.orthogonal.HyperEdgeSegment;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.LoggedGraph;

public final class DebugUtil {
    private DebugUtil() {
    }

    public static void logDebugGraph(IElkProgressMonitor monitor, LGraph lgraph, int slotIndex, String name) {
        String tag = slotIndex + "-" + name;
        monitor.logGraph(DotDebugUtil.createDebugGraph(lgraph), tag, LoggedGraph.Type.DOT);
        monitor.logGraph(JsonDebugUtil.createDebugGraph(lgraph), tag, LoggedGraph.Type.JSON);
    }

    public static void logDebugGraph(IElkProgressMonitor monitor, LGraph layeredGraph, List<LinearSegmentsNodePlacer.LinearSegment> segmentList, List<List<LinearSegmentsNodePlacer.LinearSegment>> outgoingList) {
        String tag = "segment graph";
        monitor.logGraph(DotDebugUtil.createDebugGraph(layeredGraph, segmentList, outgoingList), tag, LoggedGraph.Type.DOT);
        monitor.logGraph(JsonDebugUtil.createDebugGraph(layeredGraph, segmentList, outgoingList), tag, LoggedGraph.Type.JSON);
    }

    public static void logDebugGraph(IElkProgressMonitor monitor, LGraph layeredGraph, int layerIndex, List<HyperEdgeSegment> hypernodes, String debugPrefix, String label) {
        String tag = debugPrefix + " - " + label;
        monitor.logGraph(DotDebugUtil.createDebugGraph(layeredGraph, hypernodes), tag, LoggedGraph.Type.DOT);
        monitor.logGraph(JsonDebugUtil.createDebugGraph(layeredGraph, hypernodes), tag, LoggedGraph.Type.JSON);
    }
}

