/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import java.util.List;
import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.shape.UText;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;

public class ETileRegexGroupAllBut
extends ETile {
    private final List<String> elements1;
    private final List<String> elements2;
    private final FontConfiguration fc;
    private final Style style;
    private final HColorSet colorSet;

    public ETileRegexGroupAllBut(List<String> elements, FontConfiguration fc, Style style, HColorSet colorSet, ISkinParam skinParam) {
        this.elements1 = elements.subList(0, 1);
        this.elements2 = elements.subList(1, elements.size());
        this.fc = fc;
        this.style = style;
        this.colorSet = colorSet;
    }

    private double getHalfHeight(StringBounder stringBounder) {
        double height1 = this.getTextDim(this.elements1, stringBounder).getHeight();
        double height2 = this.getTextDim(this.elements2, stringBounder).getHeight();
        return Math.max(height1, height2) / 2.0;
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        return this.getHalfHeight(stringBounder);
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        return this.getHalfHeight(stringBounder);
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        return this.getTextDim(this.elements1, stringBounder).getWidth() + this.getTextDim(this.elements2, stringBounder).getWidth() + 20.0;
    }

    private XDimension2D getTextDim(List<String> elements, StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (String element : elements) {
            XDimension2D dim = stringBounder.calculateDimension(this.fc.getFont(), element);
            width = Math.max(width, dim.getWidth());
            height += dim.getHeight();
        }
        return new XDimension2D(width, height);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dim1 = this.getTextDim(this.elements1, stringBounder);
        XDimension2D dim2 = this.getTextDim(this.elements2, stringBounder);
        this.box(ug.apply(this.style.value(PName.LineColor).asColor(this.colorSet)), dimTotal, dim1.delta(10.0, 0.0), dim2.delta(10.0, 0.0));
        this.drawList(ug.apply(UTranslate.dy((dimTotal.getHeight() - dim1.getHeight()) / 2.0)), this.elements1);
        this.drawList(ug.apply(UTranslate.dx(10.0 + dim1.getWidth())), this.elements2);
    }

    private void box(UGraphic ug, XDimension2D dimTotal, XDimension2D dim1, XDimension2D dim2) {
        ug = ug.apply(new UStroke(5.0, 5.0, 1.0));
        ug.apply(UTranslate.dx(dim1.getWidth())).draw(URectangle.build(dim2));
        UPath path = UPath.none();
        path.moveTo(dim1.getWidth(), 0.0);
        path.lineTo(0.0, 0.0);
        path.lineTo(0.0, dim1.getHeight());
        path.lineTo(dim1.getWidth(), dim1.getHeight());
        ug.apply(UTranslate.dy((dimTotal.getHeight() - dim1.getHeight()) / 2.0)).draw(path);
    }

    private void drawList(UGraphic ug, List<String> elements) {
        StringBounder stringBounder = ug.getStringBounder();
        double totalWidth = 10.0 + this.getTextDim(this.elements1, stringBounder).getWidth();
        double y = 0.0;
        for (String element : elements) {
            UText utext = UText.build(element, this.fc);
            XDimension2D dimElement = utext.calculateDimension(stringBounder);
            ug.apply(new UTranslate(5.0, y + dimElement.getHeight() - utext.getDescent(stringBounder))).draw(utext);
            if (y > 0.0) {
                this.drawHline(ug.apply(UStroke.withThickness(0.3)), y, 0.0, totalWidth);
            }
            y += dimElement.getHeight();
        }
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }
}

