/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.ImmutableJoinAssociateRule;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.mapping.Mappings;
import org.immutables.value.Value;

@Value.Enclosing
public class JoinAssociateRule
extends RelRule<Config>
implements TransformationRule {
    protected JoinAssociateRule(Config config) {
        super(config);
    }

    @Deprecated
    public JoinAssociateRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Join topJoin = (Join)call.rel(0);
        Join bottomJoin = (Join)call.rel(1);
        RelNode relA = bottomJoin.getLeft();
        RelNode relB = bottomJoin.getRight();
        Object relC = call.rel(2);
        RelOptCluster cluster = topJoin.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        if (relC.getConvention() != relA.getConvention()) {
            return;
        }
        int aCount = relA.getRowType().getFieldCount();
        int bCount = relB.getRowType().getFieldCount();
        int cCount = relC.getRowType().getFieldCount();
        ImmutableBitSet aBitSet = ImmutableBitSet.range(0, aCount);
        ImmutableBitSet bBitSet = ImmutableBitSet.range(aCount, aCount + bCount);
        if (!topJoin.getSystemFieldList().isEmpty()) {
            return;
        }
        if (topJoin.getJoinType() != JoinRelType.INNER || bottomJoin.getJoinType() != JoinRelType.INNER) {
            return;
        }
        ArrayList<RexNode> top = new ArrayList<RexNode>();
        ArrayList<RexNode> bottom = new ArrayList<RexNode>();
        JoinPushThroughJoinRule.split(topJoin.getCondition(), aBitSet, top, bottom);
        JoinPushThroughJoinRule.split(bottomJoin.getCondition(), aBitSet, top, bottom);
        boolean allowAlwaysTrueCondition = ((Config)this.config).isAllowAlwaysTrueCondition();
        if (!allowAlwaysTrueCondition && (top.isEmpty() || bottom.isEmpty())) {
            return;
        }
        Mappings.TargetMapping bottomMapping = Mappings.createShiftMapping(aCount + bCount + cCount, 0, aCount, bCount, bCount, aCount + bCount, cCount);
        List newBottomList = new RexPermuteInputsShuttle(bottomMapping, new RelNode[]{relB, relC}).visitList(bottom);
        RexNode newBottomCondition = RexUtil.composeConjunction(rexBuilder, newBottomList);
        if (!allowAlwaysTrueCondition && newBottomCondition.isAlwaysTrue()) {
            return;
        }
        RexNode newTopCondition = RexUtil.composeConjunction(rexBuilder, top);
        if (!allowAlwaysTrueCondition && newTopCondition.isAlwaysTrue()) {
            return;
        }
        Join newBottomJoin = bottomJoin.copy(bottomJoin.getTraitSet(), newBottomCondition, relB, (RelNode)relC, JoinRelType.INNER, false);
        Join newTopJoin = topJoin.copy(topJoin.getTraitSet(), newTopCondition, relA, newBottomJoin, JoinRelType.INNER, false);
        call.transformTo(newTopJoin);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableJoinAssociateRule.Config.of().withOperandFor(Join.class);

        @Override
        default public JoinAssociateRule toRule() {
            return new JoinAssociateRule(this);
        }

        @Value.Default
        default public boolean isAllowAlwaysTrueCondition() {
            return true;
        }

        public Config withAllowAlwaysTrueCondition(boolean var1);

        default public Config withOperandFor(Class<? extends Join> joinClass) {
            return this.withOperandSupplier(b0 -> b0.operand(joinClass).inputs(b1 -> b1.operand(joinClass).anyInputs(), b2 -> b2.operand(RelNode.class).anyInputs())).as(Config.class);
        }
    }
}

