/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.Criterion;
import org.opensaml.security.httpclient.HttpClientSecurityConfiguration;

public class HttpClientSecurityConfigurationCriterion
implements Criterion {
    @Nonnull
    private List<HttpClientSecurityConfiguration> configs;

    public HttpClientSecurityConfigurationCriterion(@Nonnull @NotEmpty List<HttpClientSecurityConfiguration> configurations) {
        Constraint.isNotNull(configurations, "List of configurations cannot be null");
        this.configs = CollectionSupport.copyToList(configurations);
        Constraint.isNotEmpty(this.configs, "At least one configuration is required");
    }

    public HttpClientSecurityConfigurationCriterion(HttpClientSecurityConfiguration ... configurations) {
        Constraint.isNotNull(configurations, "List of configurations cannot be null");
        this.configs = CollectionSupport.listOf(configurations);
        Constraint.isNotEmpty(this.configs, "At least one configuration is required");
    }

    @Nonnull
    @NotEmpty
    @NotLive
    @Unmodifiable
    public List<HttpClientSecurityConfiguration> getConfigurations() {
        return this.configs;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HttpClientSecurityConfigurationCriterion [configs=");
        builder.append(this.configs);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.configs.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof HttpClientSecurityConfigurationCriterion) {
            return this.configs.equals(((HttpClientSecurityConfigurationCriterion)obj).getConfigurations());
        }
        return false;
    }
}

