/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.IBDistribution;
import org.opensearch.client.opensearch._types.IBLambda;
import org.opensearch.client.opensearch._types.TermFrequencyNormalization;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexSettingsSimilarityIb
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexSettingsSimilarityIb> {
    @Nonnull
    private final IBDistribution distribution;
    @Nonnull
    private final IBLambda lambda;
    @Nonnull
    private final TermFrequencyNormalization normalization;
    @Nonnull
    private final String type;
    public static final JsonpDeserializer<IndexSettingsSimilarityIb> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexSettingsSimilarityIb::setupIndexSettingsSimilarityIbDeserializer);

    private IndexSettingsSimilarityIb(Builder builder) {
        this.distribution = ApiTypeHelper.requireNonNull(builder.distribution, this, "distribution");
        this.lambda = ApiTypeHelper.requireNonNull(builder.lambda, this, "lambda");
        this.normalization = ApiTypeHelper.requireNonNull(builder.normalization, this, "normalization");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static IndexSettingsSimilarityIb of(Function<Builder, ObjectBuilder<IndexSettingsSimilarityIb>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final IBDistribution distribution() {
        return this.distribution;
    }

    @Nonnull
    public final IBLambda lambda() {
        return this.lambda;
    }

    @Nonnull
    public final TermFrequencyNormalization normalization() {
        return this.normalization;
    }

    @Nonnull
    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("distribution");
        this.distribution.serialize(generator, mapper);
        generator.writeKey("lambda");
        this.lambda.serialize(generator, mapper);
        generator.writeKey("normalization");
        this.normalization.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexSettingsSimilarityIbDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::distribution, IBDistribution._DESERIALIZER, "distribution");
        op.add(Builder::lambda, IBLambda._DESERIALIZER, "lambda");
        op.add(Builder::normalization, TermFrequencyNormalization._DESERIALIZER, "normalization");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.distribution.hashCode();
        result = 31 * result + this.lambda.hashCode();
        result = 31 * result + this.normalization.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexSettingsSimilarityIb other = (IndexSettingsSimilarityIb)o;
        return this.distribution.equals(other.distribution) && this.lambda.equals(other.lambda) && this.normalization.equals(other.normalization) && this.type.equals(other.type);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexSettingsSimilarityIb> {
        private IBDistribution distribution;
        private IBLambda lambda;
        private TermFrequencyNormalization normalization;
        private String type;

        public Builder() {
        }

        private Builder(IndexSettingsSimilarityIb o) {
            this.distribution = o.distribution;
            this.lambda = o.lambda;
            this.normalization = o.normalization;
            this.type = o.type;
        }

        private Builder(Builder o) {
            this.distribution = o.distribution;
            this.lambda = o.lambda;
            this.normalization = o.normalization;
            this.type = o.type;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder distribution(IBDistribution value) {
            this.distribution = value;
            return this;
        }

        @Nonnull
        public final Builder lambda(IBLambda value) {
            this.lambda = value;
            return this;
        }

        @Nonnull
        public final Builder normalization(TermFrequencyNormalization value) {
            this.normalization = value;
            return this;
        }

        @Nonnull
        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        @Nonnull
        public IndexSettingsSimilarityIb build() {
            this._checkSingleUse();
            return new IndexSettingsSimilarityIb(this);
        }
    }
}

