/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.storage.scan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Iterator;
import lombok.Generated;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.core.common.io.stream.BytesStreamInput;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.exception.NoCursorException;
import org.opensearch.sql.executor.pagination.PlanSerializer;
import org.opensearch.sql.opensearch.client.OpenSearchClient;
import org.opensearch.sql.opensearch.request.OpenSearchQueryRequest;
import org.opensearch.sql.opensearch.request.OpenSearchRequest;
import org.opensearch.sql.opensearch.response.OpenSearchResponse;
import org.opensearch.sql.opensearch.storage.OpenSearchStorageEngine;
import org.opensearch.sql.planner.SerializablePlan;
import org.opensearch.sql.storage.TableScanOperator;

public class OpenSearchIndexScan
extends TableScanOperator
implements SerializablePlan {
    private OpenSearchClient client;
    private OpenSearchRequest request;
    private int maxResponseSize;
    private Integer queryCount;
    private Iterator<ExprValue> iterator;

    public OpenSearchIndexScan(OpenSearchClient client, int maxResponseSize, OpenSearchRequest request) {
        this.maxResponseSize = maxResponseSize;
        this.client = client;
        this.request = request;
    }

    public OpenSearchIndexScan(OpenSearchClient client, OpenSearchRequest request) {
        this(client, Integer.MAX_VALUE, request);
    }

    @Override
    public void open() {
        super.open();
        this.iterator = Collections.emptyIterator();
        this.queryCount = 0;
        this.fetchNextBatch();
    }

    @Override
    public boolean hasNext() {
        if (Thread.currentThread().isInterrupted()) {
            throw new OpenSearchTimeoutException((Throwable)new InterruptedException("Query execution interrupted"));
        }
        if (this.queryCount >= this.maxResponseSize) {
            return false;
        }
        if (!this.iterator.hasNext()) {
            this.fetchNextBatch();
        }
        return this.iterator.hasNext();
    }

    @Override
    public ExprValue next() {
        if (Thread.currentThread().isInterrupted()) {
            throw new OpenSearchTimeoutException((Throwable)new InterruptedException("Query execution interrupted"));
        }
        Integer n = this.queryCount;
        this.queryCount = this.queryCount + 1;
        return this.iterator.next();
    }

    private void fetchNextBatch() {
        OpenSearchResponse response = this.client.search(this.request);
        if (!response.isEmpty()) {
            this.iterator = response.iterator();
        }
    }

    @Override
    public void close() {
        super.close();
        this.client.cleanup(this.request);
    }

    @Override
    public String explain() {
        return this.request.toString();
    }

    @Deprecated(since="introduction")
    public OpenSearchIndexScan() {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int currentRead;
        int reqSize = in.readInt();
        byte[] requestStream = new byte[reqSize];
        int read = 0;
        do {
            if ((currentRead = in.read(requestStream, read, reqSize - read)) != -1) continue;
            throw new IOException();
        } while ((read += currentRead) < reqSize);
        OpenSearchStorageEngine engine = (OpenSearchStorageEngine)((PlanSerializer.CursorDeserializationStream)in).resolveObject("engine");
        this.client = engine.getClient();
        try (BytesStreamInput bsi = new BytesStreamInput(requestStream);){
            this.request = new OpenSearchQueryRequest((StreamInput)bsi, engine);
        }
        this.maxResponseSize = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (!this.request.hasAnotherBatch()) {
            throw new NoCursorException();
        }
        BytesStreamOutput reqOut = new BytesStreamOutput();
        this.request.writeTo((StreamOutput)reqOut);
        reqOut.flush();
        byte[] reqAsBytes = reqOut.bytes().toBytesRef().bytes;
        out.writeInt(reqOut.size());
        out.write(reqAsBytes, 0, reqOut.size());
        out.writeInt(this.maxResponseSize);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSearchIndexScan)) {
            return false;
        }
        OpenSearchIndexScan other = (OpenSearchIndexScan)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.maxResponseSize != other.maxResponseSize) {
            return false;
        }
        OpenSearchRequest this$request = this.request;
        OpenSearchRequest other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OpenSearchIndexScan;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.maxResponseSize;
        OpenSearchRequest $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OpenSearchIndexScan(request=" + String.valueOf(this.request) + ", maxResponseSize=" + this.maxResponseSize + ")";
    }
}

