/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.utils.cache.stats;

import org.opensearch.index.store.remote.filecache.CachedFullFileIndexInput;
import org.opensearch.index.store.remote.utils.cache.stats.AggregateRefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.DefaultStatsCounter;
import org.opensearch.index.store.remote.utils.cache.stats.IRefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.RefCountedCacheStats;
import org.opensearch.index.store.remote.utils.cache.stats.StatsCounter;

public class FileStatsCounter<K, V>
implements StatsCounter<K, V> {
    private final DefaultStatsCounter<K, V> overallStatsCounter = new DefaultStatsCounter();
    private final DefaultStatsCounter<K, V> fullFileStatsCounter = new DefaultStatsCounter();
    private final DefaultStatsCounter<K, V> blockFileStatsCounter = new DefaultStatsCounter();
    private final DefaultStatsCounter<K, V> pinnedFileStatsCounter = new DefaultStatsCounter();

    @Override
    public void recordHits(K key, V value, boolean pinned, int count) {
        this.overallStatsCounter.recordHits(key, value, pinned, count);
        if (this.isFullFile(value)) {
            this.fullFileStatsCounter.recordHits(key, value, pinned, count);
        } else {
            this.blockFileStatsCounter.recordHits(key, value, pinned, count);
        }
        if (pinned) {
            this.pinnedFileStatsCounter.recordHits(key, value, pinned, count);
        }
    }

    @Override
    public void recordMisses(K key, int count) {
        this.overallStatsCounter.recordMisses(key, count);
        this.blockFileStatsCounter.recordMisses(key, count);
    }

    @Override
    public void recordRemoval(V value, boolean pinned, long weight) {
        this.overallStatsCounter.recordRemoval(value, pinned, weight);
        if (this.isFullFile(value)) {
            this.fullFileStatsCounter.recordRemoval(value, pinned, weight);
        } else {
            this.blockFileStatsCounter.recordRemoval(value, pinned, weight);
        }
        if (pinned) {
            this.pinnedFileStatsCounter.recordRemoval(value, pinned, weight);
        }
    }

    @Override
    public void recordReplacement(V oldValue, V newValue, long oldWeight, long newWeight, boolean shouldUpdateActiveUsage, boolean isPinned) {
        boolean isOldFullFile = this.isFullFile(oldValue);
        boolean isNewFullFile = this.isFullFile(newValue);
        this.overallStatsCounter.recordReplacement(oldValue, newValue, oldWeight, newWeight, shouldUpdateActiveUsage, isPinned);
        this.fullFileStatsCounter.recordReplacement(oldValue, newValue, isOldFullFile ? oldWeight : 0L, isNewFullFile ? newWeight : 0L, shouldUpdateActiveUsage, isPinned);
        this.blockFileStatsCounter.recordReplacement(oldValue, newValue, isOldFullFile ? 0L : oldWeight, isNewFullFile ? 0L : newWeight, shouldUpdateActiveUsage, isPinned);
    }

    @Override
    public void recordEviction(V value, long weight) {
        this.overallStatsCounter.recordEviction(value, weight);
        if (this.isFullFile(value)) {
            this.fullFileStatsCounter.recordEviction(value, weight);
        } else {
            this.blockFileStatsCounter.recordEviction(value, weight);
        }
    }

    @Override
    public void recordUsage(V value, long weight, boolean pinned, boolean shouldDecrease) {
        this.overallStatsCounter.recordUsage(value, weight, pinned, shouldDecrease);
        if (this.isFullFile(value)) {
            this.fullFileStatsCounter.recordUsage(value, weight, pinned, shouldDecrease);
        } else {
            this.blockFileStatsCounter.recordUsage(value, weight, pinned, shouldDecrease);
        }
        if (pinned) {
            this.pinnedFileStatsCounter.recordUsage(value, weight, pinned, shouldDecrease);
        }
    }

    @Override
    public void recordActiveUsage(V value, long weight, boolean pinned, boolean shouldDecrease) {
        this.overallStatsCounter.recordActiveUsage(value, weight, pinned, shouldDecrease);
        if (this.isFullFile(value)) {
            this.fullFileStatsCounter.recordActiveUsage(value, weight, pinned, shouldDecrease);
        } else {
            this.blockFileStatsCounter.recordActiveUsage(value, weight, pinned, shouldDecrease);
        }
        if (pinned) {
            this.pinnedFileStatsCounter.recordActiveUsage(value, weight, pinned, shouldDecrease);
        }
    }

    @Override
    public void recordPinnedUsage(V value, long weight, boolean shouldDecrease) {
        this.overallStatsCounter.recordPinnedUsage(value, weight, shouldDecrease);
        if (this.isFullFile(value)) {
            this.fullFileStatsCounter.recordPinnedUsage(value, weight, shouldDecrease);
        } else {
            this.blockFileStatsCounter.recordPinnedUsage(value, weight, shouldDecrease);
        }
        this.pinnedFileStatsCounter.recordPinnedUsage(value, weight, shouldDecrease);
    }

    @Override
    public void resetActiveUsage() {
        this.overallStatsCounter.resetActiveUsage();
        this.fullFileStatsCounter.resetActiveUsage();
        this.blockFileStatsCounter.resetActiveUsage();
        this.pinnedFileStatsCounter.resetActiveUsage();
    }

    @Override
    public void resetPinnedUsage() {
        this.overallStatsCounter.resetPinnedUsage();
        this.fullFileStatsCounter.resetPinnedUsage();
        this.blockFileStatsCounter.resetPinnedUsage();
        this.pinnedFileStatsCounter.resetPinnedUsage();
    }

    @Override
    public void resetUsage() {
        this.overallStatsCounter.resetUsage();
        this.fullFileStatsCounter.resetUsage();
        this.blockFileStatsCounter.resetUsage();
        this.pinnedFileStatsCounter.resetUsage();
    }

    @Override
    public long activeUsage() {
        return this.overallStatsCounter.activeUsage();
    }

    @Override
    public long usage() {
        return this.overallStatsCounter.usage();
    }

    @Override
    public long pinnedUsage() {
        return this.pinnedFileStatsCounter.pinnedUsage();
    }

    @Override
    public IRefCountedCacheStats snapshot() {
        return new AggregateRefCountedCacheStats((RefCountedCacheStats)this.overallStatsCounter.snapshot(), (RefCountedCacheStats)this.fullFileStatsCounter.snapshot(), (RefCountedCacheStats)this.blockFileStatsCounter.snapshot(), (RefCountedCacheStats)this.pinnedFileStatsCounter.snapshot());
    }

    public String toString() {
        return this.snapshot().toString();
    }

    private boolean isFullFile(V value) {
        return value instanceof CachedFullFileIndexInput;
    }
}

