/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.internal;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import oracle.rsi.RSIException;

public class PushPublisher<T>
implements oracle.rsi.PushPublisher<T> {
    private boolean isClosed = false;
    private Flow.Subscriber<? super T> rsiSubscriber;
    private AtomicLong request = new AtomicLong(0L);

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        if (this.rsiSubscriber == null) {
            this.rsiSubscriber = subscriber;
            this.rsiSubscriber.onSubscribe(new FlowSubscription());
            return;
        }
        if (!this.rsiSubscriber.equals(subscriber)) {
            String string = "A Publisher can be subscribed with only one subscriber.";
            subscriber.onError(new RSIException(string));
        }
    }

    @Override
    public synchronized void accept(T t) {
        if (this.isClosed) {
            String string = "Cannot accept. Publisher is closed.";
            throw new RSIException(string);
        }
        if (this.request.get() <= 0L) {
            String string = "Notifying memory pressure.";
            throw new RSIException(string);
        }
        this.request.decrementAndGet();
        this.rsiSubscriber.onNext(t);
    }

    @Override
    public void close() throws Exception {
        this.isClosed = true;
    }

    private class FlowSubscription
    implements Flow.Subscription {
        private boolean isCancelled = false;

        private FlowSubscription() {
        }

        @Override
        public void request(long l) {
            if (this.isCancelled) {
                return;
            }
            if (l <= 0L) {
                String string = "Non-positive request signals are illegal.";
                PushPublisher.this.rsiSubscriber.onError(new IllegalArgumentException(string));
            }
            PushPublisher.this.request.addAndGet(l);
        }

        @Override
        public void cancel() {
            if (!this.isCancelled) {
                this.isCancelled = true;
            }
        }
    }
}

