/*
 * Decompiled with CFR 0.152.
 */
package oracle.rsi.diagnostics;

import java.security.AccessController;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import java.util.logging.SimpleFormatter;

public class Diagnostic {
    private static final AtomicLong MILLIS = new AtomicLong(System.currentTimeMillis());
    private final Logger debugLogger;
    private final String loggerName;
    private MemoryHandler traceHandler;
    private static final Level DEFAULT_PUSH_LEVEL = Level.WARNING;
    private final ResourceBundle resourceBundle = null;

    public static Diagnostic get(String string, int n) {
        return new Diagnostic(string, n);
    }

    protected Diagnostic(String string, int n) {
        Handler handler;
        Logger logger;
        assert (string != null && n > 0);
        this.loggerName = string;
        for (logger = this.debugLogger = Logger.getLogger(string); logger != null && logger.getHandlers().length == 0; logger = logger.getParent()) {
        }
        Handler handler2 = handler = logger == null ? null : logger.getHandlers()[0];
        if (handler == null) {
            return;
        }
        if (handler instanceof ConsoleHandler) {
            AccessController.doPrivileged(() -> {
                try {
                    handler.setFormatter(new SimpleFormatter());
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException(securityException);
                }
                return null;
            });
        }
        this.traceHandler = new MemoryHandler(handler, n, DEFAULT_PUSH_LEVEL);
    }

    public <T extends Throwable> T trace(Level level, String string, String string2, String string3, T t, Object ... objectArray) {
        if (this.traceHandler == null) {
            return null;
        }
        Level level2 = level;
        if (level.intValue() < Level.INFO.intValue()) {
            level2 = Level.INFO;
        }
        LogRecord logRecord = this.buildAndGetLogRecord(level2, string, string2, t, string3, objectArray);
        this.traceHandler.publish(logRecord);
        if (level.intValue() >= DEFAULT_PUSH_LEVEL.intValue()) {
            this.traceHandler.push();
        }
        return t;
    }

    public <T extends Throwable> T debug(Level level, String string, String string2, String string3, T t, Object ... objectArray) {
        LogRecord logRecord = this.buildAndGetLogRecord(level, string, string2, t, string3, objectArray);
        this.debugLogger.log(logRecord);
        return t;
    }

    private LogRecord buildAndGetLogRecord(Level level, String string, String string2, Throwable throwable, String string3, Object ... objectArray) {
        LogRecord logRecord = new LogRecord(level, string3);
        logRecord.setMillis(MILLIS.getAndIncrement());
        logRecord.setLoggerName(this.loggerName);
        logRecord.setParameters(objectArray);
        logRecord.setResourceBundle(this.resourceBundle);
        logRecord.setSourceClassName(string);
        logRecord.setSourceMethodName(string2);
        logRecord.setThreadID((int)Thread.currentThread().getId());
        logRecord.setThrown(throwable);
        return logRecord;
    }
}

