/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.directwebremoting.Container;

public class ContainerMap
extends AbstractMap<String, Object>
implements Map<String, Object> {
    private final boolean filterNonStringValues;
    private final Container container;
    protected Map<String, Object> proxy;

    public ContainerMap(Container container, boolean filterNonStringValues) {
        this.container = container;
        this.filterNonStringValues = filterNonStringValues;
    }

    private void init() {
        if (this.proxy == null) {
            this.proxy = new HashMap<String, Object>();
            for (String name : this.container.getBeanNames()) {
                Object value = this.container.getBean(name);
                if (this.filterNonStringValues && !(value instanceof String)) continue;
                this.proxy.put(name, value);
            }
        }
    }

    @Override
    public Object get(Object key) {
        this.init();
        return this.proxy.get(key);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.init();
        return this.proxy.entrySet();
    }

    @Override
    public boolean containsKey(Object key) {
        this.init();
        return this.proxy.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.init();
        return this.proxy.containsValue(value);
    }

    @Override
    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (this == o) {
            return true;
        }
        this.init();
        if (o.getClass() != this.getClass()) {
            return false;
        }
        return ((Object)this.proxy).equals(o);
    }

    @Override
    public int hashCode() {
        this.init();
        return ((Object)this.proxy).hashCode();
    }

    @Override
    public boolean isEmpty() {
        this.init();
        return this.proxy.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        this.init();
        return this.proxy.keySet();
    }

    @Override
    public int size() {
        this.init();
        return this.proxy.size();
    }

    @Override
    public Collection<Object> values() {
        this.init();
        return this.proxy.values();
    }

    @Override
    public String toString() {
        this.init();
        return this.proxy.toString();
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("ContainerMaps are read only");
    }

    @Override
    public void putAll(Map<? extends String, ?> t) {
        throw new UnsupportedOperationException("ContainerMaps are read only");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("ContainerMaps are read only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("ContainerMaps are read only");
    }
}

