/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.actors;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.logging.Level;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.Chain;
import oracle.ucp.util.ListChain;
import oracle.ucp.util.Pair;

public class InterruptableActor {
    static final String CLASS_NAME = InterruptableActor.class.getName();
    private static final int AWAIT_TIMEOUT = 10;
    private static final int POLL_COUNT = 10;
    private static final int POLL_TIMEOUT = 1;
    private static final Lock lock = new ReentrantLock();
    private static final Condition condition = lock.newCondition();
    private static final ListChain<Pair<Action, Thread>> chain = new ListChain();
    private static final AtomicReference<Predicate<Pair<Action, Thread>>> predicate = new AtomicReference<Predicate<Pair>>(p -> false);
    private static volatile Thread controlThread;
    private static final ReentrantLock startStopLock;

    private static Thread buildControlThread() {
        return new Thread(() -> {
            block7: while (true) {
                try {
                    lock.lock();
                    condition.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "buildControlThread", "", null, e, new Object[0]);
                    return;
                }
                finally {
                    lock.unlock();
                }
                int i = 0;
                while (true) {
                    if (i >= 10) continue block7;
                    InterruptableActor.interruptAllAppropriateActions();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "buildControlThread", "", null, e, new Object[0]);
                        return;
                    }
                    ++i;
                }
                break;
            }
        }, InterruptableActor.class.getName() + "-control");
    }

    private static void interruptAllAppropriateActions() {
        chain.forEach(p -> {
            if (predicate.get().test((Pair<Action, Thread>)p)) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "interruptAllAppropriateActions", "about to interrupt: {0}", null, null, p.get2nd());
                ((Thread)p.get2nd()).interrupt();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UniversalPooledConnection doAction(Action action) throws UniversalConnectionPoolException {
        Chain.Atom atom = chain.add((Object)new Pair<Action, Thread>(action, Thread.currentThread()));
        try {
            UniversalPooledConnection universalPooledConnection = action.exec();
            return universalPooledConnection;
        }
        catch (InterruptedException e) {
            DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "doAction", "", null, e, new Object[0]);
            UniversalPooledConnection universalPooledConnection = null;
            return universalPooledConnection;
        }
        finally {
            ((ListChain.Atom)atom).remove();
        }
    }

    public static void registerPredicate(Predicate<Pair<Action, Thread>> predicate) {
        InterruptableActor.predicate.set(predicate);
    }

    public static void triggerInterrupts() {
        lock.lock();
        try {
            condition.signalAll();
        }
        finally {
            lock.unlock();
        }
    }

    public static void start() {
        try {
            startStopLock.lock();
            if (null != controlThread) {
                return;
            }
            controlThread = InterruptableActor.buildControlThread();
            controlThread.setDaemon(true);
            controlThread.start();
        }
        finally {
            startStopLock.unlock();
        }
    }

    public static void stop() {
        try {
            startStopLock.lock();
            if (null == controlThread) {
                return;
            }
            controlThread.interrupt();
            controlThread = null;
        }
        finally {
            startStopLock.unlock();
        }
    }

    static {
        startStopLock = new ReentrantLock();
    }

    public static interface Action {
        public UniversalPooledConnection exec() throws InterruptedException, UniversalConnectionPoolException;

        default public String getDescriptor() {
            return null;
        }
    }
}

