/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Time;
import java.util.Arrays;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.driver.TimeCopyingBinder;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class TimeBinder
extends DateCommonBinder {
    Binder theTimeCopyingBinder = null;
    Time paramVal;

    static void init(Binder x) {
        x.type = (short)12;
        x.bytelen = 7;
    }

    TimeBinder(Time x) {
        TimeBinder.init(this);
        this.paramVal = x;
    }

    @Override
    Binder copyingBinder() {
        if (this.theTimeCopyingBinder == null) {
            this.theTimeCopyingBinder = new TimeCopyingBinder();
        }
        return this.theTimeCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        Time value = this.paramVal;
        byte[] b = null;
        int offset = 0;
        int len = 7;
        long pos = 0L;
        if (clearPriorBindValues) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                b = stmt.connection.methodTempLittleByteBuffer;
                byteoffset = 0;
                offset = 0;
            } else {
                b = bindBytes;
                offset = byteoffset;
            }
            bindIndicators[indoffset] = 0;
            len = this.getDatumBytes(stmt, value, b, byteoffset);
        }
        if (bindUseDBA) {
            bindData.put(b, 0, len);
            bindDataLengths[bindDataIndex] = len;
            stmt.lastBoundDataLengths[bindPosition] = len;
            bindIndicators[lenoffset] = (short)len;
        } else {
            bindIndicators[lenoffset] = (short)bytePitch;
        }
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, value.getTime());
        }
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, Time value, byte[] b, int byteoffset) throws SQLException {
        int len = 7;
        TimeBinder.setOracleHMS(TimeBinder.setOracleCYMD(value.getTime(), b, byteoffset, stmt), b, byteoffset);
        b[0 + byteoffset] = 119;
        b[2 + byteoffset] = 1;
        b[3 + byteoffset] = 1;
        b[1 + byteoffset] = stmt.connection.use1900AsYearForTime ? 100 : -86;
        return len;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b, len), internalType, null, 0);
    }
}

