/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicReference;
import oracle.jdbc.dcn.RowChangeDescription;
import oracle.jdbc.dcn.TableChangeDescription;
import oracle.jdbc.driver.NTFDCNRowChanges;
import oracle.sql.CharacterSet;

class NTFDCNTableChanges
implements TableChangeDescription {
    private static final byte OPERATION_ANY = 0;
    private static final byte OPERATION_UNKNOWN = 64;
    final EnumSet<TableChangeDescription.TableOperation> opcode;
    String tableName;
    final int objectNumber;
    final int numberOfRows;
    ArrayList<EnumSet<RowChangeDescription.RowOperation>> rowOpcode;
    final int[] rowIdLength;
    final byte[][] rowid;
    final CharacterSet charset;
    private AtomicReference<NTFDCNRowChanges[]> rowsDescriptionRef = new AtomicReference();

    NTFDCNTableChanges(ByteBuffer buffer, int _csid) {
        this.charset = CharacterSet.make(_csid);
        this.opcode = TableChangeDescription.TableOperation.getTableOperations(buffer.getInt());
        short tableNameLength = buffer.getShort();
        byte[] tableNameBuffer = new byte[tableNameLength];
        buffer.get(tableNameBuffer, 0, tableNameLength);
        this.tableName = this.charset.toStringWithReplacement(tableNameBuffer, 0, tableNameLength);
        this.objectNumber = buffer.getInt();
        if (!this.opcode.contains((Object)TableChangeDescription.TableOperation.ALL_ROWS)) {
            this.numberOfRows = buffer.getShort();
            this.rowOpcode = new ArrayList(this.numberOfRows);
            this.rowIdLength = new int[this.numberOfRows];
            this.rowid = new byte[this.numberOfRows][];
            for (int i = 0; i < this.numberOfRows; ++i) {
                this.rowOpcode.add(RowChangeDescription.RowOperation.getRowOperations(buffer.getInt()));
                this.rowIdLength[i] = buffer.getShort();
                this.rowid[i] = new byte[this.rowIdLength[i]];
                buffer.get(this.rowid[i], 0, this.rowIdLength[i]);
            }
        } else {
            this.numberOfRows = 0;
            this.rowid = null;
            this.rowOpcode = null;
            this.rowIdLength = null;
        }
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public int getObjectNumber() {
        return this.objectNumber;
    }

    @Override
    public RowChangeDescription[] getRowChangeDescription() {
        return this.rowsDescriptionRef.updateAndGet(rdArray -> {
            if (rdArray == null) {
                NTFDCNRowChanges[] rowsDescription = new NTFDCNRowChanges[this.numberOfRows];
                Arrays.setAll(rowsDescription, i -> new NTFDCNRowChanges(this.rowOpcode.get(i), this.rowIdLength[i], this.rowid[i]));
                return rowsDescription;
            }
            return rdArray;
        });
    }

    @Override
    public EnumSet<TableChangeDescription.TableOperation> getTableOperations() {
        return this.opcode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    operation=" + this.getTableOperations() + ", tableName=" + this.tableName + ", objectNumber=" + this.objectNumber + "\n");
        RowChangeDescription[] rdesc = this.getRowChangeDescription();
        if (rdesc != null && rdesc.length > 0) {
            sb.append("    Row Change Description (length=" + rdesc.length + "):\n");
            for (int i = 0; i < rdesc.length; ++i) {
                sb.append(rdesc[i].toString());
            }
        }
        return sb.toString();
    }
}

