This module exploits three vulnerabilities in the IBM QRadar SIEM, a Forensics web application.
Chained together, they allow an attacker to achieve unauthenticated remote code execution.

The Forensics web application is disabled in QRadar Community Edition, but the code still works,
so these vulnerabilities can be exploited in all flavours of QRadar.
Due to payload constraints, this module only runs a generic/shell_reverse_tcp payload.

## Vulnerable Application

The vulnerable application can be found here: https://developer.ibm.com/qradar/ce/
You will need a valid IBM login, which can be acquired for free, in order to
download the software, but old versions are archived.

This module was tested with IBM QRadar Community Edition 7.3.0 and 7.3.1, but may not work
with the licensed versions (it is unclear if IBM backported a patch or there
was some other reason it does not work).

IBM has confirmed versions up to 7.2.8 patch 12 and 7.3.1 patch 3 are vulnerable.

## Example

```
Module options (exploit/linux/http/ibm_qradar_unauth_rce):

   Name     Current Setting  Required  Description
   ----     ---------------  --------  -----------
   Proxies                   no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                    yes       The target address
   RPORT    443              yes       The target port (TCP)
   SRVHOST  0.0.0.0          yes       HTTP server address
   SRVPORT  4448             yes       HTTP server port
   SSL      true             no        Negotiate SSL/TLS for outgoing connections
   SSLCert                   no        Path to a custom SSL certificate (default is randomly generated)
   URIPATH                   no        The URI to use for this exploit (default is random)
   VHOST                     no        HTTP server virtual host


Payload options (generic/shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   LHOST                   yes       The listen address
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   IBM QRadar SIEM <= 7.3.1 Patch 2 / 7.2.8 Patch 11
```
