# frozen_string_literal: true

module Msf
  module Mitre
    module Attack
      # This file was auto-generated by tools/dev/generate_mitre_attack_technique_constants.rb please do not manually edit it
      module Technique
        T1001_DATA_OBFUSCATION = 'T1001'
        T1001_001_JUNK_DATA = 'T1001.001'
        T1001_002_STEGANOGRAPHY = 'T1001.002'
        T1001_003_PROTOCOL_OR_SERVICE_IMPERSONATION = 'T1001.003'

        T1002_DATA_COMPRESSED = 'T1002'

        T1003_OS_CREDENTIAL_DUMPING = 'T1003'
        T1003_001_LSASS_MEMORY = 'T1003.001'
        T1003_002_SECURITY_ACCOUNT_MANAGER = 'T1003.002'
        T1003_003_NTDS = 'T1003.003'
        T1003_004_LSA_SECRETS = 'T1003.004'
        T1003_005_CACHED_DOMAIN_CREDENTIALS = 'T1003.005'
        T1003_006_DCSYNC = 'T1003.006'
        T1003_007_PROC_FILESYSTEM = 'T1003.007'
        T1003_008_ETC_PASSWD_AND_ETC_SHADOW = 'T1003.008'

        T1004_WINLOGON_HELPER_DLL = 'T1004'

        T1005_DATA_FROM_LOCAL_SYSTEM = 'T1005'

        T1006_DIRECT_VOLUME_ACCESS = 'T1006'

        T1007_SYSTEM_SERVICE_DISCOVERY = 'T1007'

        T1008_FALLBACK_CHANNELS = 'T1008'

        T1009_BINARY_PADDING = 'T1009'

        T1010_APPLICATION_WINDOW_DISCOVERY = 'T1010'

        T1011_EXFILTRATION_OVER_OTHER_NETWORK_MEDIUM = 'T1011'
        T1011_001_EXFILTRATION_OVER_BLUETOOTH = 'T1011.001'

        T1012_QUERY_REGISTRY = 'T1012'

        T1013_PORT_MONITORS = 'T1013'

        T1014_ROOTKIT = 'T1014'

        T1015_ACCESSIBILITY_FEATURES = 'T1015'

        T1016_SYSTEM_NETWORK_CONFIGURATION_DISCOVERY = 'T1016'
        T1016_001_INTERNET_CONNECTION_DISCOVERY = 'T1016.001'
        T1016_002_WI_FI_DISCOVERY = 'T1016.002'

        T1017_APPLICATION_DEPLOYMENT_SOFTWARE = 'T1017'

        T1018_REMOTE_SYSTEM_DISCOVERY = 'T1018'

        T1019_SYSTEM_FIRMWARE = 'T1019'

        T1020_AUTOMATED_EXFILTRATION = 'T1020'
        T1020_001_TRAFFIC_DUPLICATION = 'T1020.001'

        T1021_REMOTE_SERVICES = 'T1021'
        T1021_001_REMOTE_DESKTOP_PROTOCOL = 'T1021.001'
        T1021_002_SMB_WINDOWS_ADMIN_SHARES = 'T1021.002'
        T1021_003_DISTRIBUTED_COMPONENT_OBJECT_MODEL = 'T1021.003'
        T1021_004_SSH = 'T1021.004'
        T1021_005_VNC = 'T1021.005'
        T1021_006_WINDOWS_REMOTE_MANAGEMENT = 'T1021.006'
        T1021_007_CLOUD_SERVICES = 'T1021.007'
        T1021_008_DIRECT_CLOUD_VM_CONNECTIONS = 'T1021.008'

        T1022_DATA_ENCRYPTED = 'T1022'

        T1023_SHORTCUT_MODIFICATION = 'T1023'

        T1024_CUSTOM_CRYPTOGRAPHIC_PROTOCOL = 'T1024'

        T1025_DATA_FROM_REMOVABLE_MEDIA = 'T1025'

        T1026_MULTIBAND_COMMUNICATION = 'T1026'

        T1027_OBFUSCATED_FILES_OR_INFORMATION = 'T1027'
        T1027_001_BINARY_PADDING = 'T1027.001'
        T1027_002_SOFTWARE_PACKING = 'T1027.002'
        T1027_003_STEGANOGRAPHY = 'T1027.003'
        T1027_004_COMPILE_AFTER_DELIVERY = 'T1027.004'
        T1027_005_INDICATOR_REMOVAL_FROM_TOOLS = 'T1027.005'
        T1027_006_HTML_SMUGGLING = 'T1027.006'
        T1027_007_DYNAMIC_API_RESOLUTION = 'T1027.007'
        T1027_008_STRIPPED_PAYLOADS = 'T1027.008'
        T1027_009_EMBEDDED_PAYLOADS = 'T1027.009'
        T1027_010_COMMAND_OBFUSCATION = 'T1027.010'
        T1027_011_FILELESS_STORAGE = 'T1027.011'
        T1027_012_LNK_ICON_SMUGGLING = 'T1027.012'
        T1027_013_ENCRYPTED_ENCODED_FILE = 'T1027.013'
        T1027_014_POLYMORPHIC_CODE = 'T1027.014'
        T1027_015_COMPRESSION = 'T1027.015'
        T1027_016_JUNK_CODE_INSERTION = 'T1027.016'
        T1027_017_SVG_SMUGGLING = 'T1027.017'

        T1028_WINDOWS_REMOTE_MANAGEMENT = 'T1028'

        T1029_SCHEDULED_TRANSFER = 'T1029'

        T1030_DATA_TRANSFER_SIZE_LIMITS = 'T1030'

        T1031_MODIFY_EXISTING_SERVICE = 'T1031'

        T1032_STANDARD_CRYPTOGRAPHIC_PROTOCOL = 'T1032'

        T1033_SYSTEM_OWNER_USER_DISCOVERY = 'T1033'

        T1034_PATH_INTERCEPTION = 'T1034'

        T1035_SERVICE_EXECUTION = 'T1035'

        T1036_MASQUERADING = 'T1036'
        T1036_001_INVALID_CODE_SIGNATURE = 'T1036.001'
        T1036_002_RIGHT_TO_LEFT_OVERRIDE = 'T1036.002'
        T1036_003_RENAME_LEGITIMATE_UTILITIES = 'T1036.003'
        T1036_004_MASQUERADE_TASK_OR_SERVICE = 'T1036.004'
        T1036_005_MATCH_LEGITIMATE_RESOURCE_NAME_OR_LOCATION = 'T1036.005'
        T1036_006_SPACE_AFTER_FILENAME = 'T1036.006'
        T1036_007_DOUBLE_FILE_EXTENSION = 'T1036.007'
        T1036_008_MASQUERADE_FILE_TYPE = 'T1036.008'
        T1036_009_BREAK_PROCESS_TREES = 'T1036.009'
        T1036_010_MASQUERADE_ACCOUNT_NAME = 'T1036.010'
        T1036_011_OVERWRITE_PROCESS_ARGUMENTS = 'T1036.011'

        T1037_BOOT_OR_LOGON_INITIALIZATION_SCRIPTS = 'T1037'
        T1037_001_LOGON_SCRIPT_WINDOWS = 'T1037.001'
        T1037_002_LOGIN_HOOK = 'T1037.002'
        T1037_003_NETWORK_LOGON_SCRIPT = 'T1037.003'
        T1037_004_RC_SCRIPTS = 'T1037.004'
        T1037_005_STARTUP_ITEMS = 'T1037.005'

        T1038_DLL_SEARCH_ORDER_HIJACKING = 'T1038'

        T1039_DATA_FROM_NETWORK_SHARED_DRIVE = 'T1039'

        T1040_NETWORK_SNIFFING = 'T1040'

        T1041_EXFILTRATION_OVER_C2_CHANNEL = 'T1041'

        T1042_CHANGE_DEFAULT_FILE_ASSOCIATION = 'T1042'

        T1043_COMMONLY_USED_PORT = 'T1043'

        T1044_FILE_SYSTEM_PERMISSIONS_WEAKNESS = 'T1044'

        T1045_SOFTWARE_PACKING = 'T1045'

        T1046_NETWORK_SERVICE_DISCOVERY = 'T1046'

        T1047_WINDOWS_MANAGEMENT_INSTRUMENTATION = 'T1047'

        T1048_EXFILTRATION_OVER_ALTERNATIVE_PROTOCOL = 'T1048'
        T1048_001_EXFILTRATION_OVER_SYMMETRIC_ENCRYPTED_NON_C2_PROTOCOL = 'T1048.001'
        T1048_002_EXFILTRATION_OVER_ASYMMETRIC_ENCRYPTED_NON_C2_PROTOCOL = 'T1048.002'
        T1048_003_EXFILTRATION_OVER_UNENCRYPTED_NON_C2_PROTOCOL = 'T1048.003'

        T1049_SYSTEM_NETWORK_CONNECTIONS_DISCOVERY = 'T1049'

        T1050_NEW_SERVICE = 'T1050'

        T1051_SHARED_WEBROOT = 'T1051'

        T1052_EXFILTRATION_OVER_PHYSICAL_MEDIUM = 'T1052'
        T1052_001_EXFILTRATION_OVER_USB = 'T1052.001'

        T1053_SCHEDULED_TASK_JOB = 'T1053'
        T1053_001_AT_LINUX = 'T1053.001'
        T1053_002_AT = 'T1053.002'
        T1053_003_CRON = 'T1053.003'
        T1053_004_LAUNCHD = 'T1053.004'
        T1053_005_SCHEDULED_TASK = 'T1053.005'
        T1053_006_SYSTEMD_TIMERS = 'T1053.006'
        T1053_007_CONTAINER_ORCHESTRATION_JOB = 'T1053.007'

        T1054_INDICATOR_BLOCKING = 'T1054'

        T1055_PROCESS_INJECTION = 'T1055'
        T1055_001_DYNAMIC_LINK_LIBRARY_INJECTION = 'T1055.001'
        T1055_002_PORTABLE_EXECUTABLE_INJECTION = 'T1055.002'
        T1055_003_THREAD_EXECUTION_HIJACKING = 'T1055.003'
        T1055_004_ASYNCHRONOUS_PROCEDURE_CALL = 'T1055.004'
        T1055_005_THREAD_LOCAL_STORAGE = 'T1055.005'
        T1055_008_PTRACE_SYSTEM_CALLS = 'T1055.008'
        T1055_009_PROC_MEMORY = 'T1055.009'
        T1055_011_EXTRA_WINDOW_MEMORY_INJECTION = 'T1055.011'
        T1055_012_PROCESS_HOLLOWING = 'T1055.012'
        T1055_013_PROCESS_DOPPELGANGING = 'T1055.013'
        T1055_014_VDSO_HIJACKING = 'T1055.014'
        T1055_015_LISTPLANTING = 'T1055.015'

        T1056_INPUT_CAPTURE = 'T1056'
        T1056_001_KEYLOGGING = 'T1056.001'
        T1056_002_GUI_INPUT_CAPTURE = 'T1056.002'
        T1056_003_WEB_PORTAL_CAPTURE = 'T1056.003'
        T1056_004_CREDENTIAL_API_HOOKING = 'T1056.004'

        T1057_PROCESS_DISCOVERY = 'T1057'

        T1058_SERVICE_REGISTRY_PERMISSIONS_WEAKNESS = 'T1058'

        T1059_COMMAND_AND_SCRIPTING_INTERPRETER = 'T1059'
        T1059_001_POWERSHELL = 'T1059.001'
        T1059_002_APPLESCRIPT = 'T1059.002'
        T1059_003_WINDOWS_COMMAND_SHELL = 'T1059.003'
        T1059_004_UNIX_SHELL = 'T1059.004'
        T1059_005_VISUAL_BASIC = 'T1059.005'
        T1059_006_PYTHON = 'T1059.006'
        T1059_007_JAVASCRIPT = 'T1059.007'
        T1059_008_NETWORK_DEVICE_CLI = 'T1059.008'
        T1059_009_CLOUD_API = 'T1059.009'
        T1059_010_AUTOHOTKEY_AUTOIT = 'T1059.010'
        T1059_011_LUA = 'T1059.011'
        T1059_012_HYPERVISOR_CLI = 'T1059.012'

        T1060_REGISTRY_RUN_KEYS_STARTUP_FOLDER = 'T1060'

        T1061_GRAPHICAL_USER_INTERFACE = 'T1061'

        T1062_HYPERVISOR = 'T1062'

        T1063_SECURITY_SOFTWARE_DISCOVERY = 'T1063'

        T1064_SCRIPTING = 'T1064'

        T1065_UNCOMMONLY_USED_PORT = 'T1065'

        T1066_INDICATOR_REMOVAL_FROM_TOOLS = 'T1066'

        T1067_BOOTKIT = 'T1067'

        T1068_EXPLOITATION_FOR_PRIVILEGE_ESCALATION = 'T1068'

        T1069_PERMISSION_GROUPS_DISCOVERY = 'T1069'
        T1069_001_LOCAL_GROUPS = 'T1069.001'
        T1069_002_DOMAIN_GROUPS = 'T1069.002'
        T1069_003_CLOUD_GROUPS = 'T1069.003'

        T1070_INDICATOR_REMOVAL = 'T1070'
        T1070_001_CLEAR_WINDOWS_EVENT_LOGS = 'T1070.001'
        T1070_002_CLEAR_LINUX_OR_MAC_SYSTEM_LOGS = 'T1070.002'
        T1070_003_CLEAR_COMMAND_HISTORY = 'T1070.003'
        T1070_004_FILE_DELETION = 'T1070.004'
        T1070_005_NETWORK_SHARE_CONNECTION_REMOVAL = 'T1070.005'
        T1070_006_TIMESTOMP = 'T1070.006'
        T1070_007_CLEAR_NETWORK_CONNECTION_HISTORY_AND_CONFIGURATIONS = 'T1070.007'
        T1070_008_CLEAR_MAILBOX_DATA = 'T1070.008'
        T1070_009_CLEAR_PERSISTENCE = 'T1070.009'
        T1070_010_RELOCATE_MALWARE = 'T1070.010'

        T1071_APPLICATION_LAYER_PROTOCOL = 'T1071'
        T1071_001_WEB_PROTOCOLS = 'T1071.001'
        T1071_002_FILE_TRANSFER_PROTOCOLS = 'T1071.002'
        T1071_003_MAIL_PROTOCOLS = 'T1071.003'
        T1071_004_DNS = 'T1071.004'
        T1071_005_PUBLISH_SUBSCRIBE_PROTOCOLS = 'T1071.005'

        T1072_SOFTWARE_DEPLOYMENT_TOOLS = 'T1072'

        T1073_DLL_SIDE_LOADING = 'T1073'

        T1074_DATA_STAGED = 'T1074'
        T1074_001_LOCAL_DATA_STAGING = 'T1074.001'
        T1074_002_REMOTE_DATA_STAGING = 'T1074.002'

        T1075_PASS_THE_HASH = 'T1075'

        T1076_REMOTE_DESKTOP_PROTOCOL = 'T1076'

        T1077_WINDOWS_ADMIN_SHARES = 'T1077'

        T1078_VALID_ACCOUNTS = 'T1078'
        T1078_001_DEFAULT_ACCOUNTS = 'T1078.001'
        T1078_002_DOMAIN_ACCOUNTS = 'T1078.002'
        T1078_003_LOCAL_ACCOUNTS = 'T1078.003'
        T1078_004_CLOUD_ACCOUNTS = 'T1078.004'

        T1079_MULTILAYER_ENCRYPTION = 'T1079'

        T1080_TAINT_SHARED_CONTENT = 'T1080'

        T1081_CREDENTIALS_IN_FILES = 'T1081'

        T1082_SYSTEM_INFORMATION_DISCOVERY = 'T1082'

        T1083_FILE_AND_DIRECTORY_DISCOVERY = 'T1083'

        T1084_WINDOWS_MANAGEMENT_INSTRUMENTATION_EVENT_SUBSCRIPTION = 'T1084'

        T1085_RUNDLL32 = 'T1085'

        T1086_POWERSHELL = 'T1086'

        T1087_ACCOUNT_DISCOVERY = 'T1087'
        T1087_001_LOCAL_ACCOUNT = 'T1087.001'
        T1087_002_DOMAIN_ACCOUNT = 'T1087.002'
        T1087_003_EMAIL_ACCOUNT = 'T1087.003'
        T1087_004_CLOUD_ACCOUNT = 'T1087.004'

        T1088_BYPASS_USER_ACCOUNT_CONTROL = 'T1088'

        T1089_DISABLING_SECURITY_TOOLS = 'T1089'

        T1090_PROXY = 'T1090'
        T1090_001_INTERNAL_PROXY = 'T1090.001'
        T1090_002_EXTERNAL_PROXY = 'T1090.002'
        T1090_003_MULTI_HOP_PROXY = 'T1090.003'
        T1090_004_DOMAIN_FRONTING = 'T1090.004'

        T1091_REPLICATION_THROUGH_REMOVABLE_MEDIA = 'T1091'

        T1092_COMMUNICATION_THROUGH_REMOVABLE_MEDIA = 'T1092'

        T1093_PROCESS_HOLLOWING = 'T1093'

        T1094_CUSTOM_COMMAND_AND_CONTROL_PROTOCOL = 'T1094'

        T1095_NON_APPLICATION_LAYER_PROTOCOL = 'T1095'

        T1096_NTFS_FILE_ATTRIBUTES = 'T1096'

        T1097_PASS_THE_TICKET = 'T1097'

        T1098_ACCOUNT_MANIPULATION = 'T1098'
        T1098_001_ADDITIONAL_CLOUD_CREDENTIALS = 'T1098.001'
        T1098_002_ADDITIONAL_EMAIL_DELEGATE_PERMISSIONS = 'T1098.002'
        T1098_003_ADDITIONAL_CLOUD_ROLES = 'T1098.003'
        T1098_004_SSH_AUTHORIZED_KEYS = 'T1098.004'
        T1098_005_DEVICE_REGISTRATION = 'T1098.005'
        T1098_006_ADDITIONAL_CONTAINER_CLUSTER_ROLES = 'T1098.006'
        T1098_007_ADDITIONAL_LOCAL_OR_DOMAIN_GROUPS = 'T1098.007'

        T1099_TIMESTOMP = 'T1099'

        T1100_WEB_SHELL = 'T1100'

        T1101_SECURITY_SUPPORT_PROVIDER = 'T1101'

        T1102_WEB_SERVICE = 'T1102'
        T1102_001_DEAD_DROP_RESOLVER = 'T1102.001'
        T1102_002_BIDIRECTIONAL_COMMUNICATION = 'T1102.002'
        T1102_003_ONE_WAY_COMMUNICATION = 'T1102.003'

        T1103_APPINIT_DLLS = 'T1103'

        T1104_MULTI_STAGE_CHANNELS = 'T1104'

        T1105_INGRESS_TOOL_TRANSFER = 'T1105'

        T1106_NATIVE_API = 'T1106'

        T1107_FILE_DELETION = 'T1107'

        T1108_REDUNDANT_ACCESS = 'T1108'

        T1109_COMPONENT_FIRMWARE = 'T1109'

        T1110_BRUTE_FORCE = 'T1110'
        T1110_001_PASSWORD_GUESSING = 'T1110.001'
        T1110_002_PASSWORD_CRACKING = 'T1110.002'
        T1110_003_PASSWORD_SPRAYING = 'T1110.003'
        T1110_004_CREDENTIAL_STUFFING = 'T1110.004'

        T1111_MULTI_FACTOR_AUTHENTICATION_INTERCEPTION = 'T1111'

        T1112_MODIFY_REGISTRY = 'T1112'

        T1113_SCREEN_CAPTURE = 'T1113'

        T1114_EMAIL_COLLECTION = 'T1114'
        T1114_001_LOCAL_EMAIL_COLLECTION = 'T1114.001'
        T1114_002_REMOTE_EMAIL_COLLECTION = 'T1114.002'
        T1114_003_EMAIL_FORWARDING_RULE = 'T1114.003'

        T1115_CLIPBOARD_DATA = 'T1115'

        T1116_CODE_SIGNING = 'T1116'

        T1117_REGSVR32 = 'T1117'

        T1118_INSTALLUTIL = 'T1118'

        T1119_AUTOMATED_COLLECTION = 'T1119'

        T1120_PERIPHERAL_DEVICE_DISCOVERY = 'T1120'

        T1121_REGSVCS_REGASM = 'T1121'

        T1122_COMPONENT_OBJECT_MODEL_HIJACKING = 'T1122'

        T1123_AUDIO_CAPTURE = 'T1123'

        T1124_SYSTEM_TIME_DISCOVERY = 'T1124'

        T1125_VIDEO_CAPTURE = 'T1125'

        T1126_NETWORK_SHARE_CONNECTION_REMOVAL = 'T1126'

        T1127_TRUSTED_DEVELOPER_UTILITIES_PROXY_EXECUTION = 'T1127'
        T1127_001_MSBUILD = 'T1127.001'
        T1127_002_CLICKONCE = 'T1127.002'
        T1127_003_JAMPLUS = 'T1127.003'

        T1128_NETSH_HELPER_DLL = 'T1128'

        T1129_SHARED_MODULES = 'T1129'

        T1130_INSTALL_ROOT_CERTIFICATE = 'T1130'

        T1131_AUTHENTICATION_PACKAGE = 'T1131'

        T1132_DATA_ENCODING = 'T1132'
        T1132_001_STANDARD_ENCODING = 'T1132.001'
        T1132_002_NON_STANDARD_ENCODING = 'T1132.002'

        T1133_EXTERNAL_REMOTE_SERVICES = 'T1133'

        T1134_ACCESS_TOKEN_MANIPULATION = 'T1134'
        T1134_001_TOKEN_IMPERSONATION_THEFT = 'T1134.001'
        T1134_002_CREATE_PROCESS_WITH_TOKEN = 'T1134.002'
        T1134_003_MAKE_AND_IMPERSONATE_TOKEN = 'T1134.003'
        T1134_004_PARENT_PID_SPOOFING = 'T1134.004'
        T1134_005_SID_HISTORY_INJECTION = 'T1134.005'

        T1135_NETWORK_SHARE_DISCOVERY = 'T1135'

        T1136_CREATE_ACCOUNT = 'T1136'
        T1136_001_LOCAL_ACCOUNT = 'T1136.001'
        T1136_002_DOMAIN_ACCOUNT = 'T1136.002'
        T1136_003_CLOUD_ACCOUNT = 'T1136.003'

        T1137_OFFICE_APPLICATION_STARTUP = 'T1137'
        T1137_001_OFFICE_TEMPLATE_MACROS = 'T1137.001'
        T1137_002_OFFICE_TEST = 'T1137.002'
        T1137_003_OUTLOOK_FORMS = 'T1137.003'
        T1137_004_OUTLOOK_HOME_PAGE = 'T1137.004'
        T1137_005_OUTLOOK_RULES = 'T1137.005'
        T1137_006_ADD_INS = 'T1137.006'

        T1138_APPLICATION_SHIMMING = 'T1138'

        T1139_BASH_HISTORY = 'T1139'

        T1140_DEOBFUSCATE_DECODE_FILES_OR_INFORMATION = 'T1140'

        T1141_INPUT_PROMPT = 'T1141'

        T1142_KEYCHAIN = 'T1142'

        T1143_HIDDEN_WINDOW = 'T1143'

        T1144_GATEKEEPER_BYPASS = 'T1144'

        T1145_PRIVATE_KEYS = 'T1145'

        T1146_CLEAR_COMMAND_HISTORY = 'T1146'

        T1147_HIDDEN_USERS = 'T1147'

        T1148_HISTCONTROL = 'T1148'

        T1149_LC_MAIN_HIJACKING = 'T1149'

        T1150_PLIST_MODIFICATION = 'T1150'

        T1151_SPACE_AFTER_FILENAME = 'T1151'

        T1152_LAUNCHCTL = 'T1152'

        T1153_SOURCE = 'T1153'

        T1154_TRAP = 'T1154'

        T1155_APPLESCRIPT = 'T1155'

        T1156_MALICIOUS_SHELL_MODIFICATION = 'T1156'

        T1157_DYLIB_HIJACKING = 'T1157'

        T1158_HIDDEN_FILES_AND_DIRECTORIES = 'T1158'

        T1159_LAUNCH_AGENT = 'T1159'

        T1160_LAUNCH_DAEMON = 'T1160'

        T1161_LC_LOAD_DYLIB_ADDITION = 'T1161'

        T1162_LOGIN_ITEM = 'T1162'

        T1163_RC_COMMON = 'T1163'

        T1164_RE_OPENED_APPLICATIONS = 'T1164'

        T1165_STARTUP_ITEMS = 'T1165'

        T1166_SETUID_AND_SETGID = 'T1166'

        T1167_SECURITYD_MEMORY = 'T1167'

        T1168_LOCAL_JOB_SCHEDULING = 'T1168'

        T1169_SUDO = 'T1169'

        T1170_MSHTA = 'T1170'

        T1171_LLMNR_NBT_NS_POISONING_AND_RELAY = 'T1171'

        T1172_DOMAIN_FRONTING = 'T1172'

        T1173_DYNAMIC_DATA_EXCHANGE = 'T1173'

        T1174_PASSWORD_FILTER_DLL = 'T1174'

        T1175_COMPONENT_OBJECT_MODEL_AND_DISTRIBUTED_COM = 'T1175'

        T1176_SOFTWARE_EXTENSIONS = 'T1176'
        T1176_001_BROWSER_EXTENSIONS = 'T1176.001'
        T1176_002_IDE_EXTENSIONS = 'T1176.002'

        T1177_LSASS_DRIVER = 'T1177'

        T1178_SID_HISTORY_INJECTION = 'T1178'

        T1179_HOOKING = 'T1179'

        T1180_SCREENSAVER = 'T1180'

        T1181_EXTRA_WINDOW_MEMORY_INJECTION = 'T1181'

        T1182_APPCERT_DLLS = 'T1182'

        T1183_IMAGE_FILE_EXECUTION_OPTIONS_INJECTION = 'T1183'

        T1184_SSH_HIJACKING = 'T1184'

        T1185_BROWSER_SESSION_HIJACKING = 'T1185'

        T1186_PROCESS_DOPPELGANGING = 'T1186'

        T1187_FORCED_AUTHENTICATION = 'T1187'

        T1188_MULTI_HOP_PROXY = 'T1188'

        T1189_DRIVE_BY_COMPROMISE = 'T1189'

        T1190_EXPLOIT_PUBLIC_FACING_APPLICATION = 'T1190'

        T1191_CMSTP = 'T1191'

        T1192_SPEARPHISHING_LINK = 'T1192'

        T1193_SPEARPHISHING_ATTACHMENT = 'T1193'

        T1194_SPEARPHISHING_VIA_SERVICE = 'T1194'

        T1195_SUPPLY_CHAIN_COMPROMISE = 'T1195'
        T1195_001_COMPROMISE_SOFTWARE_DEPENDENCIES_AND_DEVELOPMENT_TOOLS = 'T1195.001'
        T1195_002_COMPROMISE_SOFTWARE_SUPPLY_CHAIN = 'T1195.002'
        T1195_003_COMPROMISE_HARDWARE_SUPPLY_CHAIN = 'T1195.003'

        T1196_CONTROL_PANEL_ITEMS = 'T1196'

        T1197_BITS_JOBS = 'T1197'

        T1198_SIP_AND_TRUST_PROVIDER_HIJACKING = 'T1198'

        T1199_TRUSTED_RELATIONSHIP = 'T1199'

        T1200_HARDWARE_ADDITIONS = 'T1200'

        T1201_PASSWORD_POLICY_DISCOVERY = 'T1201'

        T1202_INDIRECT_COMMAND_EXECUTION = 'T1202'

        T1203_EXPLOITATION_FOR_CLIENT_EXECUTION = 'T1203'

        T1204_USER_EXECUTION = 'T1204'
        T1204_001_MALICIOUS_LINK = 'T1204.001'
        T1204_002_MALICIOUS_FILE = 'T1204.002'
        T1204_003_MALICIOUS_IMAGE = 'T1204.003'
        T1204_004_MALICIOUS_COPY_AND_PASTE = 'T1204.004'

        T1205_TRAFFIC_SIGNALING = 'T1205'
        T1205_001_PORT_KNOCKING = 'T1205.001'
        T1205_002_SOCKET_FILTERS = 'T1205.002'

        T1206_SUDO_CACHING = 'T1206'

        T1207_ROGUE_DOMAIN_CONTROLLER = 'T1207'

        T1208_KERBEROASTING = 'T1208'

        T1209_TIME_PROVIDERS = 'T1209'

        T1210_EXPLOITATION_OF_REMOTE_SERVICES = 'T1210'

        T1211_EXPLOITATION_FOR_DEFENSE_EVASION = 'T1211'

        T1212_EXPLOITATION_FOR_CREDENTIAL_ACCESS = 'T1212'

        T1213_DATA_FROM_INFORMATION_REPOSITORIES = 'T1213'
        T1213_001_CONFLUENCE = 'T1213.001'
        T1213_002_SHAREPOINT = 'T1213.002'
        T1213_003_CODE_REPOSITORIES = 'T1213.003'
        T1213_004_CUSTOMER_RELATIONSHIP_MANAGEMENT_SOFTWARE = 'T1213.004'
        T1213_005_MESSAGING_APPLICATIONS = 'T1213.005'

        T1214_CREDENTIALS_IN_REGISTRY = 'T1214'

        T1215_KERNEL_MODULES_AND_EXTENSIONS = 'T1215'

        T1216_SYSTEM_SCRIPT_PROXY_EXECUTION = 'T1216'
        T1216_001_PUBPRN = 'T1216.001'
        T1216_002_SYNCAPPVPUBLISHINGSERVER = 'T1216.002'

        T1217_BROWSER_INFORMATION_DISCOVERY = 'T1217'

        T1218_SYSTEM_BINARY_PROXY_EXECUTION = 'T1218'
        T1218_001_COMPILED_HTML_FILE = 'T1218.001'
        T1218_002_CONTROL_PANEL = 'T1218.002'
        T1218_003_CMSTP = 'T1218.003'
        T1218_004_INSTALLUTIL = 'T1218.004'
        T1218_005_MSHTA = 'T1218.005'
        T1218_007_MSIEXEC = 'T1218.007'
        T1218_008_ODBCCONF = 'T1218.008'
        T1218_009_REGSVCS_REGASM = 'T1218.009'
        T1218_010_REGSVR32 = 'T1218.010'
        T1218_011_RUNDLL32 = 'T1218.011'
        T1218_012_VERCLSID = 'T1218.012'
        T1218_013_MAVINJECT = 'T1218.013'
        T1218_014_MMC = 'T1218.014'
        T1218_015_ELECTRON_APPLICATIONS = 'T1218.015'

        T1219_REMOTE_ACCESS_TOOLS = 'T1219'
        T1219_001_IDE_TUNNELING = 'T1219.001'
        T1219_002_REMOTE_DESKTOP_SOFTWARE = 'T1219.002'
        T1219_003_REMOTE_ACCESS_HARDWARE = 'T1219.003'

        T1220_XSL_SCRIPT_PROCESSING = 'T1220'

        T1221_TEMPLATE_INJECTION = 'T1221'

        T1222_FILE_AND_DIRECTORY_PERMISSIONS_MODIFICATION = 'T1222'
        T1222_001_WINDOWS_FILE_AND_DIRECTORY_PERMISSIONS_MODIFICATION = 'T1222.001'
        T1222_002_LINUX_AND_MAC_FILE_AND_DIRECTORY_PERMISSIONS_MODIFICATION = 'T1222.002'

        T1223_COMPILED_HTML_FILE = 'T1223'

        T1480_EXECUTION_GUARDRAILS = 'T1480'
        T1480_001_ENVIRONMENTAL_KEYING = 'T1480.001'
        T1480_002_MUTUAL_EXCLUSION = 'T1480.002'

        T1482_DOMAIN_TRUST_DISCOVERY = 'T1482'

        T1483_DOMAIN_GENERATION_ALGORITHMS = 'T1483'

        T1484_DOMAIN_OR_TENANT_POLICY_MODIFICATION = 'T1484'
        T1484_001_GROUP_POLICY_MODIFICATION = 'T1484.001'
        T1484_002_TRUST_MODIFICATION = 'T1484.002'

        T1485_DATA_DESTRUCTION = 'T1485'
        T1485_001_LIFECYCLE_TRIGGERED_DELETION = 'T1485.001'

        T1486_DATA_ENCRYPTED_FOR_IMPACT = 'T1486'

        T1487_DISK_STRUCTURE_WIPE = 'T1487'

        T1488_DISK_CONTENT_WIPE = 'T1488'

        T1489_SERVICE_STOP = 'T1489'

        T1490_INHIBIT_SYSTEM_RECOVERY = 'T1490'

        T1491_DEFACEMENT = 'T1491'
        T1491_001_INTERNAL_DEFACEMENT = 'T1491.001'
        T1491_002_EXTERNAL_DEFACEMENT = 'T1491.002'

        T1492_STORED_DATA_MANIPULATION = 'T1492'

        T1493_TRANSMITTED_DATA_MANIPULATION = 'T1493'

        T1494_RUNTIME_DATA_MANIPULATION = 'T1494'

        T1495_FIRMWARE_CORRUPTION = 'T1495'

        T1496_RESOURCE_HIJACKING = 'T1496'
        T1496_001_COMPUTE_HIJACKING = 'T1496.001'
        T1496_002_BANDWIDTH_HIJACKING = 'T1496.002'
        T1496_003_SMS_PUMPING = 'T1496.003'
        T1496_004_CLOUD_SERVICE_HIJACKING = 'T1496.004'

        T1497_VIRTUALIZATION_SANDBOX_EVASION = 'T1497'
        T1497_001_SYSTEM_CHECKS = 'T1497.001'
        T1497_002_USER_ACTIVITY_BASED_CHECKS = 'T1497.002'
        T1497_003_TIME_BASED_EVASION = 'T1497.003'

        T1498_NETWORK_DENIAL_OF_SERVICE = 'T1498'
        T1498_001_DIRECT_NETWORK_FLOOD = 'T1498.001'
        T1498_002_REFLECTION_AMPLIFICATION = 'T1498.002'

        T1499_ENDPOINT_DENIAL_OF_SERVICE = 'T1499'
        T1499_001_OS_EXHAUSTION_FLOOD = 'T1499.001'
        T1499_002_SERVICE_EXHAUSTION_FLOOD = 'T1499.002'
        T1499_003_APPLICATION_EXHAUSTION_FLOOD = 'T1499.003'
        T1499_004_APPLICATION_OR_SYSTEM_EXPLOITATION = 'T1499.004'

        T1500_COMPILE_AFTER_DELIVERY = 'T1500'

        T1501_SYSTEMD_SERVICE = 'T1501'

        T1502_PARENT_PID_SPOOFING = 'T1502'

        T1503_CREDENTIALS_FROM_WEB_BROWSERS = 'T1503'

        T1504_POWERSHELL_PROFILE = 'T1504'

        T1505_SERVER_SOFTWARE_COMPONENT = 'T1505'
        T1505_001_SQL_STORED_PROCEDURES = 'T1505.001'
        T1505_002_TRANSPORT_AGENT = 'T1505.002'
        T1505_003_WEB_SHELL = 'T1505.003'
        T1505_004_IIS_COMPONENTS = 'T1505.004'
        T1505_005_TERMINAL_SERVICES_DLL = 'T1505.005'
        T1505_006_VSPHERE_INSTALLATION_BUNDLES = 'T1505.006'

        T1506_WEB_SESSION_COOKIE = 'T1506'

        T1514_ELEVATED_EXECUTION_WITH_PROMPT = 'T1514'

        T1518_SOFTWARE_DISCOVERY = 'T1518'
        T1518_001_SECURITY_SOFTWARE_DISCOVERY = 'T1518.001'

        T1519_EMOND = 'T1519'

        T1522_CLOUD_INSTANCE_METADATA_API = 'T1522'

        T1525_IMPLANT_INTERNAL_IMAGE = 'T1525'

        T1526_CLOUD_SERVICE_DISCOVERY = 'T1526'

        T1527_APPLICATION_ACCESS_TOKEN = 'T1527'

        T1528_STEAL_APPLICATION_ACCESS_TOKEN = 'T1528'

        T1529_SYSTEM_SHUTDOWN_REBOOT = 'T1529'

        T1530_DATA_FROM_CLOUD_STORAGE = 'T1530'

        T1531_ACCOUNT_ACCESS_REMOVAL = 'T1531'

        T1534_INTERNAL_SPEARPHISHING = 'T1534'

        T1535_UNUSED_UNSUPPORTED_CLOUD_REGIONS = 'T1535'

        T1536_REVERT_CLOUD_INSTANCE = 'T1536'

        T1537_TRANSFER_DATA_TO_CLOUD_ACCOUNT = 'T1537'

        T1538_CLOUD_SERVICE_DASHBOARD = 'T1538'

        T1539_STEAL_WEB_SESSION_COOKIE = 'T1539'

        T1542_PRE_OS_BOOT = 'T1542'
        T1542_001_SYSTEM_FIRMWARE = 'T1542.001'
        T1542_002_COMPONENT_FIRMWARE = 'T1542.002'
        T1542_003_BOOTKIT = 'T1542.003'
        T1542_004_ROMMONKIT = 'T1542.004'
        T1542_005_TFTP_BOOT = 'T1542.005'

        T1543_CREATE_OR_MODIFY_SYSTEM_PROCESS = 'T1543'
        T1543_001_LAUNCH_AGENT = 'T1543.001'
        T1543_002_SYSTEMD_SERVICE = 'T1543.002'
        T1543_003_WINDOWS_SERVICE = 'T1543.003'
        T1543_004_LAUNCH_DAEMON = 'T1543.004'
        T1543_005_CONTAINER_SERVICE = 'T1543.005'

        T1546_EVENT_TRIGGERED_EXECUTION = 'T1546'
        T1546_001_CHANGE_DEFAULT_FILE_ASSOCIATION = 'T1546.001'
        T1546_002_SCREENSAVER = 'T1546.002'
        T1546_003_WINDOWS_MANAGEMENT_INSTRUMENTATION_EVENT_SUBSCRIPTION = 'T1546.003'
        T1546_004_UNIX_SHELL_CONFIGURATION_MODIFICATION = 'T1546.004'
        T1546_005_TRAP = 'T1546.005'
        T1546_006_LC_LOAD_DYLIB_ADDITION = 'T1546.006'
        T1546_007_NETSH_HELPER_DLL = 'T1546.007'
        T1546_008_ACCESSIBILITY_FEATURES = 'T1546.008'
        T1546_009_APPCERT_DLLS = 'T1546.009'
        T1546_010_APPINIT_DLLS = 'T1546.010'
        T1546_011_APPLICATION_SHIMMING = 'T1546.011'
        T1546_012_IMAGE_FILE_EXECUTION_OPTIONS_INJECTION = 'T1546.012'
        T1546_013_POWERSHELL_PROFILE = 'T1546.013'
        T1546_014_EMOND = 'T1546.014'
        T1546_015_COMPONENT_OBJECT_MODEL_HIJACKING = 'T1546.015'
        T1546_016_INSTALLER_PACKAGES = 'T1546.016'
        T1546_017_UDEV_RULES = 'T1546.017'
        T1546_018_PYTHON_STARTUP_HOOKS = 'T1546.018'
        T1547_BOOT_OR_LOGON_AUTOSTART_EXECUTION = 'T1547'
        T1547_001_REGISTRY_RUN_KEYS_STARTUP_FOLDER = 'T1547.001'
        T1547_002_AUTHENTICATION_PACKAGE = 'T1547.002'
        T1547_003_TIME_PROVIDERS = 'T1547.003'
        T1547_004_WINLOGON_HELPER_DLL = 'T1547.004'
        T1547_005_SECURITY_SUPPORT_PROVIDER = 'T1547.005'
        T1547_006_KERNEL_MODULES_AND_EXTENSIONS = 'T1547.006'
        T1547_007_RE_OPENED_APPLICATIONS = 'T1547.007'
        T1547_008_LSASS_DRIVER = 'T1547.008'
        T1547_009_SHORTCUT_MODIFICATION = 'T1547.009'
        T1547_010_PORT_MONITORS = 'T1547.010'
        T1547_011_PLIST_MODIFICATION = 'T1547.011'
        T1547_012_PRINT_PROCESSORS = 'T1547.012'
        T1547_013_XDG_AUTOSTART_ENTRIES = 'T1547.013'
        T1547_014_ACTIVE_SETUP = 'T1547.014'
        T1547_015_LOGIN_ITEMS = 'T1547.015'

        T1548_ABUSE_ELEVATION_CONTROL_MECHANISM = 'T1548'
        T1548_001_SETUID_AND_SETGID = 'T1548.001'
        T1548_002_BYPASS_USER_ACCOUNT_CONTROL = 'T1548.002'
        T1548_003_SUDO_AND_SUDO_CACHING = 'T1548.003'
        T1548_004_ELEVATED_EXECUTION_WITH_PROMPT = 'T1548.004'
        T1548_005_TEMPORARY_ELEVATED_CLOUD_ACCESS = 'T1548.005'
        T1548_006_TCC_MANIPULATION = 'T1548.006'

        T1550_USE_ALTERNATE_AUTHENTICATION_MATERIAL = 'T1550'
        T1550_001_APPLICATION_ACCESS_TOKEN = 'T1550.001'
        T1550_002_PASS_THE_HASH = 'T1550.002'
        T1550_003_PASS_THE_TICKET = 'T1550.003'
        T1550_004_WEB_SESSION_COOKIE = 'T1550.004'

        T1552_UNSECURED_CREDENTIALS = 'T1552'
        T1552_001_CREDENTIALS_IN_FILES = 'T1552.001'
        T1552_002_CREDENTIALS_IN_REGISTRY = 'T1552.002'
        T1552_003_BASH_HISTORY = 'T1552.003'
        T1552_004_PRIVATE_KEYS = 'T1552.004'
        T1552_005_CLOUD_INSTANCE_METADATA_API = 'T1552.005'
        T1552_006_GROUP_POLICY_PREFERENCES = 'T1552.006'
        T1552_007_CONTAINER_API = 'T1552.007'
        T1552_008_CHAT_MESSAGES = 'T1552.008'

        T1553_SUBVERT_TRUST_CONTROLS = 'T1553'
        T1553_001_GATEKEEPER_BYPASS = 'T1553.001'
        T1553_002_CODE_SIGNING = 'T1553.002'
        T1553_003_SIP_AND_TRUST_PROVIDER_HIJACKING = 'T1553.003'
        T1553_004_INSTALL_ROOT_CERTIFICATE = 'T1553.004'
        T1553_005_MARK_OF_THE_WEB_BYPASS = 'T1553.005'
        T1553_006_CODE_SIGNING_POLICY_MODIFICATION = 'T1553.006'

        T1554_COMPROMISE_HOST_SOFTWARE_BINARY = 'T1554'

        T1555_CREDENTIALS_FROM_PASSWORD_STORES = 'T1555'
        T1555_001_KEYCHAIN = 'T1555.001'
        T1555_002_SECURITYD_MEMORY = 'T1555.002'
        T1555_003_CREDENTIALS_FROM_WEB_BROWSERS = 'T1555.003'
        T1555_004_WINDOWS_CREDENTIAL_MANAGER = 'T1555.004'
        T1555_005_PASSWORD_MANAGERS = 'T1555.005'
        T1555_006_CLOUD_SECRETS_MANAGEMENT_STORES = 'T1555.006'

        T1556_MODIFY_AUTHENTICATION_PROCESS = 'T1556'
        T1556_001_DOMAIN_CONTROLLER_AUTHENTICATION = 'T1556.001'
        T1556_002_PASSWORD_FILTER_DLL = 'T1556.002'
        T1556_003_PLUGGABLE_AUTHENTICATION_MODULES = 'T1556.003'
        T1556_004_NETWORK_DEVICE_AUTHENTICATION = 'T1556.004'
        T1556_005_REVERSIBLE_ENCRYPTION = 'T1556.005'
        T1556_006_MULTI_FACTOR_AUTHENTICATION = 'T1556.006'
        T1556_007_HYBRID_IDENTITY = 'T1556.007'
        T1556_008_NETWORK_PROVIDER_DLL = 'T1556.008'
        T1556_009_CONDITIONAL_ACCESS_POLICIES = 'T1556.009'

        T1557_ADVERSARY_IN_THE_MIDDLE = 'T1557'
        T1557_001_LLMNR_NBT_NS_POISONING_AND_SMB_RELAY = 'T1557.001'
        T1557_002_ARP_CACHE_POISONING = 'T1557.002'
        T1557_003_DHCP_SPOOFING = 'T1557.003'
        T1557_004_EVIL_TWIN = 'T1557.004'

        T1558_STEAL_OR_FORGE_KERBEROS_TICKETS = 'T1558'
        T1558_001_GOLDEN_TICKET = 'T1558.001'
        T1558_002_SILVER_TICKET = 'T1558.002'
        T1558_003_KERBEROASTING = 'T1558.003'
        T1558_004_AS_REP_ROASTING = 'T1558.004'
        T1558_005_CCACHE_FILES = 'T1558.005'

        T1559_INTER_PROCESS_COMMUNICATION = 'T1559'
        T1559_001_COMPONENT_OBJECT_MODEL = 'T1559.001'
        T1559_002_DYNAMIC_DATA_EXCHANGE = 'T1559.002'
        T1559_003_XPC_SERVICES = 'T1559.003'

        T1560_ARCHIVE_COLLECTED_DATA = 'T1560'
        T1560_001_ARCHIVE_VIA_UTILITY = 'T1560.001'
        T1560_002_ARCHIVE_VIA_LIBRARY = 'T1560.002'
        T1560_003_ARCHIVE_VIA_CUSTOM_METHOD = 'T1560.003'

        T1561_DISK_WIPE = 'T1561'
        T1561_001_DISK_CONTENT_WIPE = 'T1561.001'
        T1561_002_DISK_STRUCTURE_WIPE = 'T1561.002'

        T1562_IMPAIR_DEFENSES = 'T1562'
        T1562_001_DISABLE_OR_MODIFY_TOOLS = 'T1562.001'
        T1562_002_DISABLE_WINDOWS_EVENT_LOGGING = 'T1562.002'
        T1562_003_IMPAIR_COMMAND_HISTORY_LOGGING = 'T1562.003'
        T1562_004_DISABLE_OR_MODIFY_SYSTEM_FIREWALL = 'T1562.004'
        T1562_006_INDICATOR_BLOCKING = 'T1562.006'
        T1562_007_DISABLE_OR_MODIFY_CLOUD_FIREWALL = 'T1562.007'
        T1562_008_DISABLE_OR_MODIFY_CLOUD_LOGS = 'T1562.008'
        T1562_009_SAFE_MODE_BOOT = 'T1562.009'
        T1562_010_DOWNGRADE_ATTACK = 'T1562.010'
        T1562_011_SPOOF_SECURITY_ALERTING = 'T1562.011'
        T1562_012_DISABLE_OR_MODIFY_LINUX_AUDIT_SYSTEM = 'T1562.012'

        T1563_REMOTE_SERVICE_SESSION_HIJACKING = 'T1563'
        T1563_001_SSH_HIJACKING = 'T1563.001'
        T1563_002_RDP_HIJACKING = 'T1563.002'

        T1564_HIDE_ARTIFACTS = 'T1564'
        T1564_001_HIDDEN_FILES_AND_DIRECTORIES = 'T1564.001'
        T1564_002_HIDDEN_USERS = 'T1564.002'
        T1564_003_HIDDEN_WINDOW = 'T1564.003'
        T1564_004_NTFS_FILE_ATTRIBUTES = 'T1564.004'
        T1564_005_HIDDEN_FILE_SYSTEM = 'T1564.005'
        T1564_006_RUN_VIRTUAL_INSTANCE = 'T1564.006'
        T1564_007_VBA_STOMPING = 'T1564.007'
        T1564_008_EMAIL_HIDING_RULES = 'T1564.008'
        T1564_009_RESOURCE_FORKING = 'T1564.009'
        T1564_010_PROCESS_ARGUMENT_SPOOFING = 'T1564.010'
        T1564_011_IGNORE_PROCESS_INTERRUPTS = 'T1564.011'
        T1564_012_FILE_PATH_EXCLUSIONS = 'T1564.012'
        T1564_013_BIND_MOUNTS = 'T1564.013'
        T1564_014_EXTENDED_ATTRIBUTES = 'T1564.014'

        T1565_DATA_MANIPULATION = 'T1565'
        T1565_001_STORED_DATA_MANIPULATION = 'T1565.001'
        T1565_002_TRANSMITTED_DATA_MANIPULATION = 'T1565.002'
        T1565_003_RUNTIME_DATA_MANIPULATION = 'T1565.003'

        T1566_PHISHING = 'T1566'
        T1566_001_SPEARPHISHING_ATTACHMENT = 'T1566.001'
        T1566_002_SPEARPHISHING_LINK = 'T1566.002'
        T1566_003_SPEARPHISHING_VIA_SERVICE = 'T1566.003'
        T1566_004_SPEARPHISHING_VOICE = 'T1566.004'

        T1567_EXFILTRATION_OVER_WEB_SERVICE = 'T1567'
        T1567_001_EXFILTRATION_TO_CODE_REPOSITORY = 'T1567.001'
        T1567_002_EXFILTRATION_TO_CLOUD_STORAGE = 'T1567.002'
        T1567_003_EXFILTRATION_TO_TEXT_STORAGE_SITES = 'T1567.003'
        T1567_004_EXFILTRATION_OVER_WEBHOOK = 'T1567.004'

        T1568_DYNAMIC_RESOLUTION = 'T1568'
        T1568_001_FAST_FLUX_DNS = 'T1568.001'
        T1568_002_DOMAIN_GENERATION_ALGORITHMS = 'T1568.002'
        T1568_003_DNS_CALCULATION = 'T1568.003'

        T1569_SYSTEM_SERVICES = 'T1569'
        T1569_001_LAUNCHCTL = 'T1569.001'
        T1569_002_SERVICE_EXECUTION = 'T1569.002'
        T1569_003_SYSTEMCTL = 'T1569.003'

        T1570_LATERAL_TOOL_TRANSFER = 'T1570'

        T1571_NON_STANDARD_PORT = 'T1571'

        T1572_PROTOCOL_TUNNELING = 'T1572'

        T1573_ENCRYPTED_CHANNEL = 'T1573'
        T1573_001_SYMMETRIC_CRYPTOGRAPHY = 'T1573.001'
        T1573_002_ASYMMETRIC_CRYPTOGRAPHY = 'T1573.002'

        T1574_HIJACK_EXECUTION_FLOW = 'T1574'
        T1574_001_DLL = 'T1574.001'
        T1574_002_DLL_SIDE_LOADING = 'T1574.002'
        T1574_004_DYLIB_HIJACKING = 'T1574.004'
        T1574_005_EXECUTABLE_INSTALLER_FILE_PERMISSIONS_WEAKNESS = 'T1574.005'
        T1574_006_DYNAMIC_LINKER_HIJACKING = 'T1574.006'
        T1574_007_PATH_INTERCEPTION_BY_PATH_ENVIRONMENT_VARIABLE = 'T1574.007'
        T1574_008_PATH_INTERCEPTION_BY_SEARCH_ORDER_HIJACKING = 'T1574.008'
        T1574_009_PATH_INTERCEPTION_BY_UNQUOTED_PATH = 'T1574.009'
        T1574_010_SERVICES_FILE_PERMISSIONS_WEAKNESS = 'T1574.010'
        T1574_011_SERVICES_REGISTRY_PERMISSIONS_WEAKNESS = 'T1574.011'
        T1574_012_COR_PROFILER = 'T1574.012'
        T1574_013_KERNELCALLBACKTABLE = 'T1574.013'
        T1574_014_APPDOMAINMANAGER = 'T1574.014'

        T1578_MODIFY_CLOUD_COMPUTE_INFRASTRUCTURE = 'T1578'
        T1578_001_CREATE_SNAPSHOT = 'T1578.001'
        T1578_002_CREATE_CLOUD_INSTANCE = 'T1578.002'
        T1578_003_DELETE_CLOUD_INSTANCE = 'T1578.003'
        T1578_004_REVERT_CLOUD_INSTANCE = 'T1578.004'
        T1578_005_MODIFY_CLOUD_COMPUTE_CONFIGURATIONS = 'T1578.005'

        T1580_CLOUD_INFRASTRUCTURE_DISCOVERY = 'T1580'

        T1583_ACQUIRE_INFRASTRUCTURE = 'T1583'
        T1583_001_DOMAINS = 'T1583.001'
        T1583_002_DNS_SERVER = 'T1583.002'
        T1583_003_VIRTUAL_PRIVATE_SERVER = 'T1583.003'
        T1583_004_SERVER = 'T1583.004'
        T1583_005_BOTNET = 'T1583.005'
        T1583_006_WEB_SERVICES = 'T1583.006'
        T1583_007_SERVERLESS = 'T1583.007'
        T1583_008_MALVERTISING = 'T1583.008'

        T1584_COMPROMISE_INFRASTRUCTURE = 'T1584'
        T1584_001_DOMAINS = 'T1584.001'
        T1584_002_DNS_SERVER = 'T1584.002'
        T1584_003_VIRTUAL_PRIVATE_SERVER = 'T1584.003'
        T1584_004_SERVER = 'T1584.004'
        T1584_005_BOTNET = 'T1584.005'
        T1584_006_WEB_SERVICES = 'T1584.006'
        T1584_007_SERVERLESS = 'T1584.007'
        T1584_008_NETWORK_DEVICES = 'T1584.008'

        T1585_ESTABLISH_ACCOUNTS = 'T1585'
        T1585_001_SOCIAL_MEDIA_ACCOUNTS = 'T1585.001'
        T1585_002_EMAIL_ACCOUNTS = 'T1585.002'
        T1585_003_CLOUD_ACCOUNTS = 'T1585.003'

        T1586_COMPROMISE_ACCOUNTS = 'T1586'
        T1586_001_SOCIAL_MEDIA_ACCOUNTS = 'T1586.001'
        T1586_002_EMAIL_ACCOUNTS = 'T1586.002'
        T1586_003_CLOUD_ACCOUNTS = 'T1586.003'

        T1587_DEVELOP_CAPABILITIES = 'T1587'
        T1587_001_MALWARE = 'T1587.001'
        T1587_002_CODE_SIGNING_CERTIFICATES = 'T1587.002'
        T1587_003_DIGITAL_CERTIFICATES = 'T1587.003'
        T1587_004_EXPLOITS = 'T1587.004'

        T1588_OBTAIN_CAPABILITIES = 'T1588'
        T1588_001_MALWARE = 'T1588.001'
        T1588_002_TOOL = 'T1588.002'
        T1588_003_CODE_SIGNING_CERTIFICATES = 'T1588.003'
        T1588_004_DIGITAL_CERTIFICATES = 'T1588.004'
        T1588_005_EXPLOITS = 'T1588.005'
        T1588_006_VULNERABILITIES = 'T1588.006'
        T1588_007_ARTIFICIAL_INTELLIGENCE = 'T1588.007'

        T1589_GATHER_VICTIM_IDENTITY_INFORMATION = 'T1589'
        T1589_001_CREDENTIALS = 'T1589.001'
        T1589_002_EMAIL_ADDRESSES = 'T1589.002'
        T1589_003_EMPLOYEE_NAMES = 'T1589.003'

        T1590_GATHER_VICTIM_NETWORK_INFORMATION = 'T1590'
        T1590_001_DOMAIN_PROPERTIES = 'T1590.001'
        T1590_002_DNS = 'T1590.002'
        T1590_003_NETWORK_TRUST_DEPENDENCIES = 'T1590.003'
        T1590_004_NETWORK_TOPOLOGY = 'T1590.004'
        T1590_005_IP_ADDRESSES = 'T1590.005'
        T1590_006_NETWORK_SECURITY_APPLIANCES = 'T1590.006'

        T1591_GATHER_VICTIM_ORG_INFORMATION = 'T1591'
        T1591_001_DETERMINE_PHYSICAL_LOCATIONS = 'T1591.001'
        T1591_002_BUSINESS_RELATIONSHIPS = 'T1591.002'
        T1591_003_IDENTIFY_BUSINESS_TEMPO = 'T1591.003'
        T1591_004_IDENTIFY_ROLES = 'T1591.004'

        T1592_GATHER_VICTIM_HOST_INFORMATION = 'T1592'
        T1592_001_HARDWARE = 'T1592.001'
        T1592_002_SOFTWARE = 'T1592.002'
        T1592_003_FIRMWARE = 'T1592.003'
        T1592_004_CLIENT_CONFIGURATIONS = 'T1592.004'

        T1593_SEARCH_OPEN_WEBSITES_DOMAINS = 'T1593'
        T1593_001_SOCIAL_MEDIA = 'T1593.001'
        T1593_002_SEARCH_ENGINES = 'T1593.002'
        T1593_003_CODE_REPOSITORIES = 'T1593.003'

        T1594_SEARCH_VICTIM_OWNED_WEBSITES = 'T1594'

        T1595_ACTIVE_SCANNING = 'T1595'
        T1595_001_SCANNING_IP_BLOCKS = 'T1595.001'
        T1595_002_VULNERABILITY_SCANNING = 'T1595.002'
        T1595_003_WORDLIST_SCANNING = 'T1595.003'

        T1596_SEARCH_OPEN_TECHNICAL_DATABASES = 'T1596'
        T1596_001_DNS_PASSIVE_DNS = 'T1596.001'
        T1596_002_WHOIS = 'T1596.002'
        T1596_003_DIGITAL_CERTIFICATES = 'T1596.003'
        T1596_004_CDNS = 'T1596.004'
        T1596_005_SCAN_DATABASES = 'T1596.005'

        T1597_SEARCH_CLOSED_SOURCES = 'T1597'
        T1597_001_THREAT_INTEL_VENDORS = 'T1597.001'
        T1597_002_PURCHASE_TECHNICAL_DATA = 'T1597.002'

        T1598_PHISHING_FOR_INFORMATION = 'T1598'
        T1598_001_SPEARPHISHING_SERVICE = 'T1598.001'
        T1598_002_SPEARPHISHING_ATTACHMENT = 'T1598.002'
        T1598_003_SPEARPHISHING_LINK = 'T1598.003'
        T1598_004_SPEARPHISHING_VOICE = 'T1598.004'

        T1599_NETWORK_BOUNDARY_BRIDGING = 'T1599'
        T1599_001_NETWORK_ADDRESS_TRANSLATION_TRAVERSAL = 'T1599.001'

        T1600_WEAKEN_ENCRYPTION = 'T1600'
        T1600_001_REDUCE_KEY_SPACE = 'T1600.001'
        T1600_002_DISABLE_CRYPTO_HARDWARE = 'T1600.002'

        T1601_MODIFY_SYSTEM_IMAGE = 'T1601'
        T1601_001_PATCH_SYSTEM_IMAGE = 'T1601.001'
        T1601_002_DOWNGRADE_SYSTEM_IMAGE = 'T1601.002'

        T1602_DATA_FROM_CONFIGURATION_REPOSITORY = 'T1602'
        T1602_001_SNMP_MIB_DUMP = 'T1602.001'
        T1602_002_NETWORK_DEVICE_CONFIGURATION_DUMP = 'T1602.002'

        T1606_FORGE_WEB_CREDENTIALS = 'T1606'
        T1606_001_WEB_COOKIES = 'T1606.001'
        T1606_002_SAML_TOKENS = 'T1606.002'

        T1608_STAGE_CAPABILITIES = 'T1608'
        T1608_001_UPLOAD_MALWARE = 'T1608.001'
        T1608_002_UPLOAD_TOOL = 'T1608.002'
        T1608_003_INSTALL_DIGITAL_CERTIFICATE = 'T1608.003'
        T1608_004_DRIVE_BY_TARGET = 'T1608.004'
        T1608_005_LINK_TARGET = 'T1608.005'
        T1608_006_SEO_POISONING = 'T1608.006'

        T1609_CONTAINER_ADMINISTRATION_COMMAND = 'T1609'

        T1610_DEPLOY_CONTAINER = 'T1610'

        T1611_ESCAPE_TO_HOST = 'T1611'

        T1612_BUILD_IMAGE_ON_HOST = 'T1612'

        T1613_CONTAINER_AND_RESOURCE_DISCOVERY = 'T1613'

        T1614_SYSTEM_LOCATION_DISCOVERY = 'T1614'
        T1614_001_SYSTEM_LANGUAGE_DISCOVERY = 'T1614.001'

        T1615_GROUP_POLICY_DISCOVERY = 'T1615'

        T1619_CLOUD_STORAGE_OBJECT_DISCOVERY = 'T1619'

        T1620_REFLECTIVE_CODE_LOADING = 'T1620'

        T1621_MULTI_FACTOR_AUTHENTICATION_REQUEST_GENERATION = 'T1621'

        T1622_DEBUGGER_EVASION = 'T1622'

        T1647_PLIST_FILE_MODIFICATION = 'T1647'

        T1648_SERVERLESS_EXECUTION = 'T1648'

        T1649_STEAL_OR_FORGE_AUTHENTICATION_CERTIFICATES = 'T1649'

        T1650_ACQUIRE_ACCESS = 'T1650'

        T1651_CLOUD_ADMINISTRATION_COMMAND = 'T1651'

        T1652_DEVICE_DRIVER_DISCOVERY = 'T1652'

        T1653_POWER_SETTINGS = 'T1653'

        T1654_LOG_ENUMERATION = 'T1654'

        T1656_IMPERSONATION = 'T1656'

        T1657_FINANCIAL_THEFT = 'T1657'

        T1659_CONTENT_INJECTION = 'T1659'

        T1665_HIDE_INFRASTRUCTURE = 'T1665'

        T1666_MODIFY_CLOUD_RESOURCE_HIERARCHY = 'T1666'

        T1667_EMAIL_BOMBING = 'T1667'

        T1668_EXCLUSIVE_CONTROL = 'T1668'

        T1669_WI_FI_NETWORKS = 'T1669'

        T1671_CLOUD_APPLICATION_INTEGRATION = 'T1671'

        T1672_EMAIL_SPOOFING = 'T1672'

        T1673_VIRTUAL_MACHINE_DISCOVERY = 'T1673'

        T1674_INPUT_INJECTION = 'T1674'

        T1675_ESXI_ADMINISTRATION_COMMAND = 'T1675'
      end
    end
  end
end
