/*
 * Decompiled with CFR 0.152.
 */
package airsquared.JMacNotification;

import airsquared.JMacNotification.NSArray;
import airsquared.JMacNotification.NSDateComponents;
import airsquared.JMacNotification.NSObject;
import airsquared.JMacNotification.NSUserNotificationAction;
import airsquared.JMacNotification.natives.NSTypes;
import airsquared.JMacNotification.natives.NSUserNotifications;
import com.sun.jna.Pointer;
import java.io.File;
import java.time.LocalDateTime;
import java.util.TimeZone;

public class NSUserNotification
implements NSObject {
    private Pointer pointer;

    public NSUserNotification() {
        this.pointer = NSUserNotifications.create();
    }

    public NSUserNotification(Pointer p) {
        this.pointer = p;
    }

    public NSUserNotification(String title, String subtitle, String informativeText) {
        this.setTitle(title);
        this.setTitle(subtitle);
        this.setInformativeText(informativeText);
    }

    public String getTitle() {
        return NSUserNotifications.getTitle(this.pointer);
    }

    public void setTitle(String title) {
        NSUserNotifications.setTitle(this.pointer, title);
    }

    public String getSubtitle() {
        return NSUserNotifications.getSubtitle(this.pointer);
    }

    public void setSubtitle(String subtitle) {
        NSUserNotifications.setSubtitle(this.pointer, subtitle);
    }

    public String getInformativeText() {
        return NSUserNotifications.getInformativeText(this.pointer);
    }

    public void setInformativeText(String informativeText) {
        NSUserNotifications.setInformativeText(this.pointer, informativeText);
    }

    public void setContentImage(File contentImage) {
        NSUserNotifications.setContentImagePath(this.pointer, contentImage.getAbsolutePath());
    }

    public String getIdentifier() {
        return NSUserNotifications.getIdentifier(this.pointer);
    }

    public void setIdentifier(String identifier) {
        NSUserNotifications.setIdentifier(this.pointer, identifier);
    }

    public String getResponse() {
        return NSUserNotifications.getResponse(this.pointer);
    }

    public String getResponsePlaceholder() {
        return NSUserNotifications.getResponsePlaceholder(this.pointer);
    }

    public void setResponsePlaceholder(String responsePlaceholder) {
        NSUserNotifications.setResponsePlaceholder(this.pointer, responsePlaceholder);
    }

    public boolean getHasActionButton() {
        return NSUserNotifications.getHasActionButton(this.pointer);
    }

    public void setHasActionButton(boolean hasActionButton) {
        NSUserNotifications.setHasActionButton(this.pointer, hasActionButton);
    }

    public String getActionButtonTitle() {
        return NSUserNotifications.getActionButtonTitle(this.pointer);
    }

    public void setActionButtonTitle(String actionButtonTitle) {
        NSUserNotifications.setActionButtonTitle(this.pointer, actionButtonTitle);
    }

    public String getOtherButtonTitle() {
        return NSUserNotifications.getOtherButtonTitle(this.pointer);
    }

    public void setOtherButtonTitle(String otherButtonTitle) {
        NSUserNotifications.setOtherButtonTitle(this.pointer, otherButtonTitle);
    }

    public boolean getHasReplyButton() {
        return NSUserNotifications.getHasReplyButton(this.pointer);
    }

    public void setHasReplyButton(boolean hasReplyButton) {
        NSUserNotifications.setHasReplyButton(this.pointer, hasReplyButton);
    }

    public LocalDateTime getDeliveryDate() {
        return new NSDateComponents(NSTypes.toDateComponents(NSUserNotifications.getDeliveryDate(this.pointer))).toLocalDateTime();
    }

    public void setDeliveryDate(LocalDateTime deliveryDate) {
        NSUserNotifications.setDeliveryDate(this.pointer, NSDateComponents.fromLocalDateTime(deliveryDate).toNSDate());
    }

    public LocalDateTime getActualDeliveryDate() {
        return new NSDateComponents(NSTypes.toDateComponents(NSUserNotifications.getActualDeliveryDate(this.pointer))).toLocalDateTime();
    }

    public NSDateComponents getDeliveryRepeatInterval() {
        return new NSDateComponents(NSUserNotifications.getDeliveryRepeatInterval(this.pointer));
    }

    public void setDeliveryRepeatInterval(NSDateComponents deliveryRepeatInterval) {
        NSUserNotifications.setDeliveryRepeatInterval(this.pointer, deliveryRepeatInterval.getPointer());
    }

    public TimeZone getDeliveryTimeZone() {
        return TimeZone.getTimeZone(NSUserNotifications.getDeliveryTimeZone(this.pointer));
    }

    public void setDeliveryTimeZone(TimeZone deliveryTimeZone) {
        NSUserNotifications.setDeliveryTimeZone(this.pointer, deliveryTimeZone.getID());
    }

    public boolean isPresented() {
        return NSUserNotifications.getIsPresented(this.pointer);
    }

    public boolean isRemote() {
        return NSUserNotifications.getIsRemote(this.pointer);
    }

    public String getSoundName() {
        return NSUserNotifications.getSoundName(this.pointer);
    }

    public void setSoundName(String soundName) {
        NSUserNotifications.setSoundName(this.pointer, soundName);
    }

    public NSUserNotificationActivationType getActivationType() {
        return NSUserNotificationActivationType.valueOf(NSUserNotifications.getActivationType(this.pointer));
    }

    public NSUserNotificationAction getAdditionalActivationAction() {
        return new NSUserNotificationAction(NSUserNotifications.getAdditionalActivationAction(this.pointer));
    }

    public NSArray getAdditionalActions() {
        return new NSArray(NSUserNotifications.getAdditionalActionsArray(this.pointer));
    }

    public void setAdditionalActions(NSArray additionalActions) {
        NSUserNotifications.setAdditionalActionsArray(this.pointer, additionalActions.getPointer());
    }

    public void show() {
        NSUserNotifications.showNotification(this.pointer);
    }

    public static String getDefaultSoundName() {
        return NSUserNotifications.getNSUserNotificationDefaultSoundName();
    }

    @Override
    public Pointer getPointer() {
        return this.pointer;
    }

    @Override
    public String nativeType() {
        return "NSUserNotification";
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pointer) {
            return NSTypes.isEqual(this.pointer, (Pointer)obj);
        }
        if (obj instanceof NSObject) {
            return NSTypes.isEqual(this.pointer, ((NSObject)obj).getPointer());
        }
        return false;
    }

    public int hashCode() {
        return NSTypes.hash(this.pointer);
    }

    public static enum NSUserNotificationActivationType {
        NSUserNotificationActivationTypeNone,
        NSUserNotificationActivationTypeContentsClicked,
        NSUserNotificationActivationTypeActionButtonClicked,
        NSUserNotificationActivationTypeReplied,
        NSUserNotificationActivationTypeAdditionalActionClicked;


        public Pointer toNative() {
            return NSTypes.toNSUserNotificationActivationType(this.toString());
        }

        public static NSUserNotificationActivationType fromNative(Pointer objCNSUserNotificationActivationType) {
            return NSUserNotificationActivationType.valueOf(NSTypes.toStringNSUserNotificationActivation(objCNSUserNotificationActivationType));
        }
    }
}

