"use strict";
/*
Copyright 2019 The Matrix.org Foundation C.I.C.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IrcAction = void 0;
const ircFormatting = __importStar(require("../irc/formatting"));
const logging_1 = __importDefault(require("../logging"));
const log = (0, logging_1.default)("MatrixAction");
const ACTION_TYPES = ["message", "emote", "topic", "notice"];
class IrcAction {
    type;
    text;
    ts;
    constructor(type, text, ts = 0) {
        this.type = type;
        this.text = text;
        this.ts = ts;
        if (!ACTION_TYPES.includes(type)) {
            throw new Error("Unknown IrcAction type: " + type);
        }
    }
    static fromMatrixAction(matrixAction) {
        switch (matrixAction.type) {
            case "message":
            case "emote":
            case "notice":
                if (matrixAction.text === null) {
                    break;
                }
                if (matrixAction.htmlText) {
                    const ircText = ircFormatting.htmlToIrc(matrixAction.htmlText)
                        ?? ircFormatting.markdownCodeToIrc(matrixAction.text)
                        ?? matrixAction.text; // fallback if needed.
                    if (ircText === null) {
                        throw Error("ircText is null");
                    }
                    // irc formatted text is the main text part
                    return new IrcAction(matrixAction.type, ircText, matrixAction.ts);
                }
                return new IrcAction(matrixAction.type, matrixAction.text, matrixAction.ts);
            case "image":
                return new IrcAction("emote", "uploaded an image: " + matrixAction.text, matrixAction.ts);
            case "video":
                return new IrcAction("emote", "uploaded a video: " + matrixAction.text, matrixAction.ts);
            case "audio":
                return new IrcAction("emote", "uploaded an audio file: " + matrixAction.text, matrixAction.ts);
            case "file":
                return new IrcAction("emote", "posted a file: " + matrixAction.text, matrixAction.ts);
            case "topic":
                if (matrixAction.text === null) {
                    break;
                }
                return new IrcAction(matrixAction.type, matrixAction.text, matrixAction.ts);
            default:
                log.error("IrcAction.fromMatrixAction: Unknown action: %s", matrixAction.type);
        }
        return null;
    }
}
exports.IrcAction = IrcAction;
//# sourceMappingURL=IrcAction.js.map