/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Trace;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Sort;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.store.ObjectCacheHashMap;

public class Cache {
    final DataFileCache dataFileCache;
    private int capacity;
    private long bytesCapacity;
    private final CachedObjectComparator rowComparator;
    private CachedObject[] rowTable;
    private final ObjectCacheHashMap cacheMap;
    long cacheBytesLength;
    StopWatch saveAllTimer = new StopWatch(false);
    StopWatch makeRowTimer = new StopWatch(false);
    StopWatch sortTimer = new StopWatch(false);
    int makeRowCount = 0;
    int saveRowCount = 0;

    Cache(DataFileCache dataFileCache) {
        this.dataFileCache = dataFileCache;
        this.capacity = dataFileCache.capacity();
        this.bytesCapacity = dataFileCache.bytesCapacity();
        this.rowComparator = new CachedObjectComparator();
        this.rowTable = new CachedObject[this.capacity];
        this.cacheMap = new ObjectCacheHashMap(this.capacity);
        this.cacheBytesLength = 0L;
    }

    void init(int n, long l) {
    }

    int size() {
        return this.cacheMap.size();
    }

    long getTotalCachedBlockSize() {
        return this.cacheBytesLength;
    }

    synchronized CachedObject get(int n) {
        return (CachedObject)this.cacheMap.get(n);
    }

    synchronized void put(int n, CachedObject cachedObject) throws IOException {
        int n2 = cachedObject.getStorageSize();
        if (this.cacheMap.size() >= this.capacity || (long)n2 + this.cacheBytesLength > this.bytesCapacity) {
            this.cleanUp();
        }
        this.cacheMap.put(n, cachedObject);
        this.cacheBytesLength += (long)n2;
    }

    synchronized CachedObject release(int n) {
        CachedObject cachedObject = (CachedObject)this.cacheMap.remove(n);
        if (cachedObject == null) {
            return null;
        }
        this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        return cachedObject;
    }

    private synchronized void cleanUp() throws IOException {
        int n = this.cacheMap.size() / 2;
        int n2 = this.cacheMap.getAccessCountCeiling(n, n / 8);
        ObjectCacheHashMap.ObjectCacheIterator objectCacheIterator = this.cacheMap.iterator();
        int n3 = 0;
        while (objectCacheIterator.hasNext()) {
            CachedObject cachedObject = (CachedObject)objectCacheIterator.next();
            if (objectCacheIterator.getAccessCount() > n2 || cachedObject.isKeepInMemory()) continue;
            if (cachedObject.hasChanged()) {
                this.rowTable[n3++] = cachedObject;
            }
            objectCacheIterator.remove();
            this.cacheBytesLength -= (long)cachedObject.getStorageSize();
        }
        this.cacheMap.setAccessCountFloor(n2);
        this.saveRows(n3);
    }

    private synchronized void saveRows(int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.rowComparator.setType(1);
        this.sortTimer.start();
        Sort.sort(this.rowTable, this.rowComparator, 0, n - 1);
        this.sortTimer.stop();
        this.saveAllTimer.start();
        this.dataFileCache.saveRows(this.rowTable, 0, n);
        this.saveRowCount += n;
        this.saveAllTimer.stop();
    }

    synchronized void saveAll() throws IOException {
        ObjectCacheHashMap.ObjectCacheIterator objectCacheIterator = this.cacheMap.iterator();
        int n = 0;
        while (objectCacheIterator.hasNext()) {
            CachedObject cachedObject = (CachedObject)objectCacheIterator.next();
            if (!cachedObject.hasChanged()) continue;
            this.rowTable[n++] = cachedObject;
        }
        this.saveRows(n);
        Trace.printSystemOut(this.saveAllTimer.elapsedTimeToMessage("Cache.saveRow() total row save time"));
        Trace.printSystemOut("Cache.saveRow() total row save count = " + this.saveRowCount);
        Trace.printSystemOut(this.makeRowTimer.elapsedTimeToMessage("Cache.makeRow() total row load time"));
        Trace.printSystemOut("Cache.makeRow() total row load count = " + this.makeRowCount);
        Trace.printSystemOut(this.sortTimer.elapsedTimeToMessage("Cache.sort() total time"));
    }

    synchronized void clear() {
        this.cacheMap.clear();
        this.cacheBytesLength = 0L;
    }

    static class CachedObjectComparator
    implements ObjectComparator {
        static final int COMPARE_LAST_ACCESS = 0;
        static final int COMPARE_POSITION = 1;
        static final int COMPARE_SIZE = 2;
        private int compareType;

        CachedObjectComparator() {
        }

        void setType(int n) {
            this.compareType = n;
        }

        @Override
        public int compare(Object object, Object object2) {
            switch (this.compareType) {
                case 1: {
                    return ((CachedObject)object).getPos() - ((CachedObject)object2).getPos();
                }
                case 2: {
                    return ((CachedObject)object).getStorageSize() - ((CachedObject)object2).getStorageSize();
                }
            }
            return 0;
        }
    }
}

