/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.socket;

import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnectionBroadcaster;
import com.sun.star.io.XStreamListener;
import com.sun.star.uno.Exception;
import com.sun.star.uno.RuntimeException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;

public class SocketConnection
implements XConnection,
XConnectionBroadcaster {
    public static final boolean DEBUG = false;
    protected String _description;
    protected Socket _socket;
    protected InputStream _inputStream;
    protected OutputStream _outputStream;
    protected ArrayList<XStreamListener> _listeners;
    protected boolean _firstRead;

    public SocketConnection(String string, Socket socket) throws IOException {
        this._description = string + ",localHost=" + socket.getLocalAddress().getHostName() + ",localPort=" + socket.getLocalPort() + ",peerHost=" + socket.getInetAddress().getHostName() + ",peerPort=" + socket.getPort();
        this._socket = socket;
        this._inputStream = new BufferedInputStream(socket.getInputStream());
        this._outputStream = new BufferedOutputStream(socket.getOutputStream());
        this._listeners = new ArrayList();
        this._firstRead = true;
    }

    @Override
    public void addStreamListener(XStreamListener xStreamListener) throws RuntimeException {
        this._listeners.add(xStreamListener);
    }

    @Override
    public void removeStreamListener(XStreamListener xStreamListener) throws RuntimeException {
        this._listeners.remove(xStreamListener);
    }

    private void notifyListeners_open() {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.started();
        }
    }

    private void notifyListeners_close() {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.closed();
        }
    }

    private void notifyListeners_error(Exception exception) {
        for (XStreamListener xStreamListener : this._listeners) {
            xStreamListener.error(exception);
        }
    }

    @Override
    public int read(byte[][] byArray, int n) throws com.sun.star.io.IOException, RuntimeException {
        if (this._firstRead) {
            this._firstRead = false;
            this.notifyListeners_open();
        }
        String string = null;
        int n2 = 0;
        byArray[0] = new byte[n];
        try {
            int n3;
            do {
                if ((n3 = this._inputStream.read(byArray[0], n2, n - n2)) != -1) continue;
                string = "EOF reached - " + this.getDescription();
            } while ((n2 += n3) >= 0 && n2 < n && n3 >= 0);
        }
        catch (IOException iOException) {
            string = iOException.toString();
        }
        if (string != null) {
            com.sun.star.io.IOException iOException = new com.sun.star.io.IOException(string);
            this.notifyListeners_error(iOException);
            throw iOException;
        }
        return n2;
    }

    @Override
    public void write(byte[] byArray) throws com.sun.star.io.IOException, RuntimeException {
        try {
            this._outputStream.write(byArray);
        }
        catch (IOException iOException) {
            com.sun.star.io.IOException iOException2 = new com.sun.star.io.IOException(iOException);
            this.notifyListeners_error(iOException2);
            throw iOException2;
        }
    }

    @Override
    public void flush() throws com.sun.star.io.IOException, RuntimeException {
        try {
            this._outputStream.flush();
        }
        catch (IOException iOException) {
            com.sun.star.io.IOException iOException2 = new com.sun.star.io.IOException(iOException);
            this.notifyListeners_error(iOException2);
            throw iOException2;
        }
    }

    @Override
    public void close() throws com.sun.star.io.IOException, RuntimeException {
        try {
            this._socket.close();
        }
        catch (IOException iOException) {
            com.sun.star.io.IOException iOException2 = new com.sun.star.io.IOException(iOException);
            this.notifyListeners_error(iOException2);
            throw iOException2;
        }
        this.notifyListeners_close();
    }

    @Override
    public String getDescription() throws RuntimeException {
        return this._description;
    }
}

