/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.common;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.io.XActiveDataSink;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XTextInputStream;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lib.util.StringHelper;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XFileIdentifierConverter;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.XMacroExpander;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class FileAccess {
    private XSimpleFileAccess2 fileAccess;

    private static String deleteLastSlashfromUrl(String string) {
        if (string.endsWith("/")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static String getOfficePath(XMultiServiceFactory xMultiServiceFactory, String string) {
        try {
            String string2 = PropertyNames.EMPTY_STRING;
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.util.PathSettings");
            string2 = AnyConverter.toString((Object)Helper.getUnoPropertyValue(xInterface, string));
            string2 = FileAccess.deleteLastSlashfromUrl(string2);
            return string2;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return PropertyNames.EMPTY_STRING;
        }
    }

    public static String getOfficePath(XMultiServiceFactory xMultiServiceFactory, String string, String string2, String string3) throws NoValidPathException {
        String string4 = PropertyNames.EMPTY_STRING;
        String string5 = PropertyNames.EMPTY_STRING;
        boolean bl = false;
        try {
            int n;
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.util.PathSettings");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
            String string6 = PropertyNames.EMPTY_STRING;
            String[] stringArray = null;
            XInterface xInterface2 = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface2);
            string5 = (String)xPropertySet.getPropertyValue(string + "_writable");
            String[] stringArray2 = (String[])xPropertySet.getPropertyValue(string + "_internal");
            String[] stringArray3 = (String[])xPropertySet.getPropertyValue(string + "_user");
            int n2 = stringArray3.length + stringArray2.length + 1;
            stringArray = new String[n2];
            int n3 = 0;
            for (n = 0; n < stringArray2.length; ++n) {
                stringArray[n3] = stringArray2[n];
                ++n3;
            }
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray[n3] = stringArray3[n];
                ++n3;
            }
            stringArray[n3] = string5;
            string6 = string5;
            if (string2.equalsIgnoreCase("user")) {
                string4 = string6;
                bl = true;
            } else {
                for (n = 0; n < stringArray.length; ++n) {
                    String string7 = stringArray[n] + string3;
                    if (!xSimpleFileAccess.exists(string7)) continue;
                    string4 = stringArray[n];
                    bl = true;
                    break;
                }
            }
            string4 = FileAccess.deleteLastSlashfromUrl(string4);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            string4 = PropertyNames.EMPTY_STRING;
        }
        if (!bl) {
            throw new NoValidPathException(xMultiServiceFactory, PropertyNames.EMPTY_STRING);
        }
        return string4;
    }

    public static ArrayList<String> getOfficePaths(XMultiServiceFactory xMultiServiceFactory, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = PropertyNames.EMPTY_STRING;
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.util.PathSettings");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xInterface);
            string2 = (String)xPropertySet.getPropertyValue(string + "_writable");
            String[] stringArray = (String[])xPropertySet.getPropertyValue(string + "_internal");
            String[] stringArray2 = (String[])xPropertySet.getPropertyValue(string + "_user");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (string3.toLowerCase().startsWith("vnd.sun.star.expand:")) {
                    String string4 = URLDecoder.decode(StringHelper.replace((String)string3.substring("vnd.sun.star.expand:".length()), (char)'+', (String)"%2B"), "UTF-8");
                    XMacroExpander xMacroExpander = Helper.getMacroExpander(xMultiServiceFactory);
                    string3 = xMacroExpander.expandMacros(string4);
                }
                string3 = FileAccess.checkIfLanguagePathExists(xMultiServiceFactory, string3);
                arrayList.add(string3);
            }
            arrayList.addAll(Arrays.asList(stringArray2));
            arrayList.add(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        return arrayList;
    }

    private static String checkIfLanguagePathExists(XMultiServiceFactory xMultiServiceFactory, String string) {
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.text.Defaults");
            Locale locale = (Locale)Helper.getUnoStructValue(object, "CharLocale");
            if (locale == null) {
                locale = new Locale();
                locale.Country = java.util.Locale.getDefault().getCountry();
                locale.Language = java.util.Locale.getDefault().getLanguage();
                locale.Variant = java.util.Locale.getDefault().getVariant();
            }
            String string2 = locale.Language;
            String string3 = locale.Country;
            String string4 = locale.Variant;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2).append('-').append(string3).append('-').append(string4);
            String string5 = string + "/" + stringBuffer.toString();
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(string2).append('-').append(string3);
            string5 = string + "/" + stringBuffer2.toString();
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
            StringBuffer stringBuffer3 = new StringBuffer();
            stringBuffer3.append(string2);
            string5 = string + "/" + stringBuffer3.toString();
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
            string5 = string + "/en-US";
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
            string5 = string + "/en";
            if (xSimpleFileAccess.exists(string5)) {
                return string5;
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static void combinePaths(XMultiServiceFactory xMultiServiceFactory, ArrayList<String> arrayList, String string) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = arrayList.get(i);
            if (FileAccess.isPathValid(xMultiServiceFactory, string2 = FileAccess.addPath(string2, string))) {
                arrayList.add(i, string2);
                arrayList.remove(i + 1);
                continue;
            }
            arrayList.remove(i);
            --i;
        }
    }

    public static boolean isPathValid(XMultiServiceFactory xMultiServiceFactory, String string) {
        boolean bl = false;
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            bl = xSimpleFileAccess.exists(string);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
        return bl;
    }

    public static String combinePaths(XMultiServiceFactory xMultiServiceFactory, String string, String string2) throws NoValidPathException {
        boolean bl = false;
        String string3 = PropertyNames.EMPTY_STRING;
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            string3 = string + string2;
            bl = xSimpleFileAccess.exists(string3);
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return PropertyNames.EMPTY_STRING;
        }
        if (!bl) {
            throw new NoValidPathException(xMultiServiceFactory, PropertyNames.EMPTY_STRING);
        }
        return string3;
    }

    private static String addPath(String string, String string2) {
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        String string3 = string + string2;
        return string3;
    }

    public static String getPathFromList(XMultiServiceFactory xMultiServiceFactory, ArrayList<String> arrayList, String string) {
        String string2 = PropertyNames.EMPTY_STRING;
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = arrayList.get(i);
                if (!xSimpleFileAccess.exists(string3 = FileAccess.addPath(string3, string))) continue;
                string2 = string3;
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String[][] getFolderTitles(XMultiServiceFactory xMultiServiceFactory, String string, ArrayList<String> arrayList) throws NoValidPathException {
        return FileAccess.getFolderTitles(xMultiServiceFactory, string, arrayList, PropertyNames.EMPTY_STRING);
    }

    private static String getTitle(XMultiServiceFactory xMultiServiceFactory, String string) {
        String string2 = PropertyNames.EMPTY_STRING;
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.document.DocumentProperties");
            XDocumentProperties xDocumentProperties = (XDocumentProperties)UnoRuntime.queryInterface(XDocumentProperties.class, (Object)xInterface);
            PropertyValue[] propertyValueArray = new PropertyValue[]{};
            xDocumentProperties.loadFromMedium(string, propertyValueArray);
            string2 = xDocumentProperties.getTitle();
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String[][] getFolderTitles(XMultiServiceFactory xMultiServiceFactory, String string, ArrayList<String> arrayList, String string2) throws NoValidPathException {
        String[] stringArray;
        String[][] stringArray2 = new String[2][];
        if (arrayList.isEmpty()) {
            throw new NoValidPathException(null, "Path not given.");
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        XSimpleFileAccess xSimpleFileAccess = null;
        try {
            XInterface xInterface = (XInterface)xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)xInterface);
        }
        catch (com.sun.star.uno.Exception exception) {
            throw new NoValidPathException(null, "Internal error.", exception);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray = arrayList.get(i);
            try {
                String[] stringArray3 = xSimpleFileAccess.getFolderContents((String)stringArray, false);
                string = string == null || string.equals(PropertyNames.EMPTY_STRING) ? null : string + "-";
                String string3 = PropertyNames.EMPTY_STRING;
                for (int j = 0; j < stringArray3.length; ++j) {
                    String string4;
                    string3 = FileAccess.getFilename(stringArray3[j]);
                    if (string != null && !string3.startsWith(string)) continue;
                    if (string2.equals(PropertyNames.EMPTY_STRING)) {
                        string4 = FileAccess.getTitle(xMultiServiceFactory, stringArray3[j]);
                    } else {
                        if (!string3.endsWith(string2)) continue;
                        string4 = string3 = string3.replaceAll(string2 + "$", PropertyNames.EMPTY_STRING);
                    }
                    arrayList3.add(stringArray3[j]);
                    arrayList2.add(string4);
                }
                continue;
            }
            catch (CommandAbortedException commandAbortedException) {
                commandAbortedException.printStackTrace(System.err);
                continue;
            }
            catch (com.sun.star.uno.Exception exception) {
                // empty catch block
            }
        }
        String[] stringArray4 = new String[arrayList3.size()];
        stringArray = new String[arrayList2.size()];
        arrayList3.toArray(stringArray4);
        arrayList2.toArray(stringArray);
        stringArray2[1] = stringArray4;
        stringArray2[0] = stringArray;
        JavaTools.bubblesortList(stringArray2);
        return stringArray2;
    }

    public FileAccess(XMultiServiceFactory xMultiServiceFactory) throws com.sun.star.uno.Exception {
        Object object = xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
        this.fileAccess = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)object);
        Object object2 = xMultiServiceFactory.createInstance("com.sun.star.ucb.FileContentProvider");
        UnoRuntime.queryInterface(XFileIdentifierConverter.class, (Object)object2);
    }

    private static String getExtension(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            return PropertyNames.EMPTY_STRING;
        }
        while ((n = (string = string.substring(n + 1)).indexOf(46)) > -1) {
        }
        return string;
    }

    public boolean exists(String string, boolean bl) {
        try {
            return this.fileAccess.exists(string);
        }
        catch (CommandAbortedException commandAbortedException) {
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static String getFilename(String string) {
        return FileAccess.getFilename(string, "/");
    }

    private static String getFilename(String string, String string2) {
        String[] stringArray = JavaTools.ArrayoutofString(string, string2);
        return stringArray[stringArray.length - 1];
    }

    public static String getBasename(String string, String string2) {
        String string3 = FileAccess.getFilename(string, string2);
        String string4 = FileAccess.getExtension(string3);
        return string3.substring(0, string3.length() - (string4.length() + 1));
    }

    public static String[] getDataFromTextFile(XMultiServiceFactory xMultiServiceFactory, String string) {
        String[] stringArray = null;
        try {
            Vector<String> vector = new Vector<String>();
            Object object = xMultiServiceFactory.createInstance("com.sun.star.ucb.SimpleFileAccess");
            XSimpleFileAccess xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)object);
            if (xSimpleFileAccess.exists(string)) {
                XInputStream xInputStream = xSimpleFileAccess.openFileRead(string);
                Object object2 = xMultiServiceFactory.createInstance("com.sun.star.io.TextInputStream");
                XTextInputStream xTextInputStream = (XTextInputStream)UnoRuntime.queryInterface(XTextInputStream.class, (Object)object2);
                XActiveDataSink xActiveDataSink = (XActiveDataSink)UnoRuntime.queryInterface(XActiveDataSink.class, (Object)object2);
                xActiveDataSink.setInputStream(xInputStream);
                while (!xTextInputStream.isEOF()) {
                    vector.addElement(xTextInputStream.readLine());
                }
                xTextInputStream.closeInput();
                stringArray = new String[vector.size()];
                vector.toArray(stringArray);
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
        }
        return stringArray;
    }
}

