/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

class BDJSocketFactory
implements SocketImplFactory {
    private boolean server = false;
    private static final Logger logger = Logger.getLogger(BDJSocketFactory.class.getName());

    protected static void init() {
        try {
            Socket.setSocketImplFactory(new BDJSocketFactory(false));
            ServerSocket.setSocketFactory(new BDJSocketFactory(true));
        }
        catch (IOException e) {
            logger.error("Failed to hook SocketFactory: " + e);
        }
    }

    private BDJSocketFactory(boolean server) {
        this.server = server;
    }

    private SocketImpl newSocket() {
        try {
            return (SocketImpl)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Class<?> defaultSocketImpl = Class.forName("java.net.SocksSocketImpl");
                    Constructor<?> constructor = defaultSocketImpl.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return constructor.newInstance(new Object[0]);
                }
            });
        }
        catch (PrivilegedActionException e) {
            logger.error("Failed to create socket: " + e.getException() + " at " + Logger.dumpStack());
            throw new RuntimeException(e.getException());
        }
    }

    @Override
    public SocketImpl createSocketImpl() {
        if (this.server) {
            logger.error("Xlet tried to create server socket");
            throw new RuntimeException("server sockets disabled");
        }
        SocketImpl socket = this.newSocket();
        BDJXletContext ctx = BDJXletContext.getCurrentContext();
        if (ctx != null) {
            logger.info("Xlet " + ctx + " created new socket");
            ctx.addSocket(socket);
        } else {
            logger.error("New socket created outside of Xlet context: " + Logger.dumpStack());
        }
        return socket;
    }
}

