/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.wagon.shared.http;

import org.jetbrains.kotlin.org.apache.http.HttpResponse;
import org.jetbrains.kotlin.org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.jetbrains.kotlin.org.apache.http.protocol.HttpContext;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class StandardServiceUnavailableRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private final int maxRetries;
    private final long retryInterval;

    public StandardServiceUnavailableRetryStrategy(int maxRetries, int retryInterval) {
        Args.positive(maxRetries, "Max retries");
        Args.positive(retryInterval, "Retry interval");
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
    }

    @Override
    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        int statusCode = response.getStatusLine().getStatusCode();
        boolean retryableStatusCode = statusCode == 408 || statusCode == 429 || statusCode == 500 || statusCode == 502 || statusCode == 503 || statusCode == 504;
        return executionCount <= this.maxRetries && retryableStatusCode;
    }

    @Override
    public long getRetryInterval() {
        return this.retryInterval;
    }
}

