/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.tls.main;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.Collection;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.client.tls.HostnameVerifier;
import org.mariadb.jdbc.client.tls.MariaDbX509EphemeralTrustingManager;
import org.mariadb.jdbc.client.tls.MariaDbX509KeyManager;
import org.mariadb.jdbc.client.tls.MariaDbX509TrustingManager;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.export.SslMode;
import org.mariadb.jdbc.plugin.TlsSocketPlugin;
import org.mariadb.jdbc.util.log.Logger;
import org.mariadb.jdbc.util.log.Loggers;

public class DefaultTlsSocketPlugin
implements TlsSocketPlugin {
    private static final Logger logger = Loggers.getLogger(DefaultTlsSocketPlugin.class);

    private static KeyManager loadClientCerts(String keyStoreUrl, String keyStorePassword, String keyPassword, String storeType, ExceptionFactory exceptionFactory) throws SQLException {
        MariaDbX509KeyManager mariaDbX509KeyManager;
        block8: {
            InputStream inStream = DefaultTlsSocketPlugin.loadFromUrl(keyStoreUrl);
            try {
                char[] keyStorePasswordChars;
                char[] cArray = keyStorePassword == null ? null : (keyStorePasswordChars = keyStorePassword.equals("") ? null : keyStorePassword.toCharArray());
                char[] keyStoreChars = keyPassword == null ? keyStorePasswordChars : (char[])(keyPassword.equals("") ? null : keyPassword.toCharArray());
                KeyStore ks = KeyStore.getInstance(storeType != null ? storeType : KeyStore.getDefaultType());
                ks.load(inStream, keyStorePasswordChars);
                mariaDbX509KeyManager = new MariaDbX509KeyManager(ks, keyStoreChars);
                if (inStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GeneralSecurityException ex) {
                    throw exceptionFactory.create("Failed to read keyStore file. Option keyStore=" + keyStoreUrl, "08000", ex);
                }
            }
            inStream.close();
        }
        return mariaDbX509KeyManager;
    }

    private static InputStream loadFromUrl(String keyStoreUrl) throws FileNotFoundException {
        try {
            return new URI(keyStoreUrl).toURL().openStream();
        }
        catch (Exception exception) {
            return new FileInputStream(keyStoreUrl);
        }
    }

    private static InputStream getInputStreamFromPath(String path) throws IOException {
        try {
            return new URI(path).toURL().openStream();
        }
        catch (Exception e) {
            if (path.startsWith("-----")) {
                return new ByteArrayInputStream(path.getBytes());
            }
            File f = new File(path);
            if (f.exists() && !f.isDirectory()) {
                return f.toURI().toURL().openStream();
            }
            throw new IOException(String.format("File not found for option `serverSslCert` (value: '%s')", path), e);
        }
    }

    @Override
    public String type() {
        return "DEFAULT";
    }

    @Override
    public TrustManager[] getTrustManager(Configuration conf, ExceptionFactory exceptionFactory, HostAddress hostAddress) throws SQLException {
        SslMode sslMode;
        TrustManager[] trustManager = null;
        SslMode sslMode2 = sslMode = hostAddress.sslMode == null ? conf.sslMode() : hostAddress.sslMode;
        if (sslMode == SslMode.TRUST) {
            trustManager = new X509TrustManager[]{new MariaDbX509TrustingManager()};
        } else {
            if (conf.serverSslCert() != null || conf.trustStore() != null) {
                InputStream inStream;
                KeyStore ks;
                try {
                    ks = KeyStore.getInstance(conf.trustStoreType() != null ? conf.trustStoreType() : KeyStore.getDefaultType());
                }
                catch (GeneralSecurityException generalSecurityEx) {
                    throw exceptionFactory.create("Failed to create keystore instance", "08000", generalSecurityEx);
                }
                if (conf.trustStore() != null) {
                    try {
                        inStream = DefaultTlsSocketPlugin.loadFromUrl(conf.trustStore());
                    }
                    catch (IOException ioexception) {
                        try {
                            inStream = new FileInputStream(conf.trustStore());
                        }
                        catch (FileNotFoundException fileNotFoundEx) {
                            throw new SQLException("Failed to find trustStore file. trustStore=" + conf.trustStore(), "08000", fileNotFoundEx);
                        }
                    }
                    try {
                        ks.load(inStream, conf.trustStorePassword() == null ? null : conf.trustStorePassword().toCharArray());
                    }
                    catch (IOException | NoSuchAlgorithmException | CertificateException ioEx) {
                        throw exceptionFactory.create("Failed load keyStore", "08000", ioEx);
                    }
                    finally {
                        try {
                            inStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                try {
                    inStream = DefaultTlsSocketPlugin.getInputStreamFromPath(conf.serverSslCert());
                    try {
                        ks.load(null);
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        Collection<? extends Certificate> caList = cf.generateCertificates(inStream);
                        for (Certificate certificate : caList) {
                            ks.setCertificateEntry(UUID.randomUUID().toString(), certificate);
                        }
                    }
                    finally {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                }
                catch (IOException ioEx) {
                    throw exceptionFactory.create("Failed load keyStore", "08000", ioEx);
                }
                catch (GeneralSecurityException generalSecurityEx) {
                    throw exceptionFactory.create("Failed to store certificate from serverSslCert into a keyStore", "08000", generalSecurityEx);
                }
                try {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    for (TrustManager trustManager2 : tmf.getTrustManagers()) {
                        if (!(trustManager2 instanceof X509TrustManager)) continue;
                        trustManager = new X509TrustManager[]{new MariaDbX509EphemeralTrustingManager((X509TrustManager)trustManager2)};
                    }
                }
                catch (GeneralSecurityException generalSecurityEx) {
                    throw exceptionFactory.create("Failed to load certificates from serverSslCert/trustStore", "08000", generalSecurityEx);
                }
            } else if (conf.fallbackToSystemTrustStore()) {
                try {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init((KeyStore)null);
                    for (TrustManager tm : tmf.getTrustManagers()) {
                        if (!(tm instanceof X509TrustManager)) continue;
                        trustManager = new X509TrustManager[]{new MariaDbX509EphemeralTrustingManager((X509TrustManager)tm)};
                        break;
                    }
                }
                catch (Exception e) {
                    throw new SQLException("No X509TrustManager found", e);
                }
            }
            if (trustManager == null) {
                throw new SQLException("No X509TrustManager found");
            }
        }
        return trustManager;
    }

    @Override
    public KeyManager[] getKeyManager(Configuration conf, ExceptionFactory exceptionFactory) throws SQLException {
        KeyManager[] keyManager = null;
        if (conf.keyStore() != null) {
            keyManager = new KeyManager[]{DefaultTlsSocketPlugin.loadClientCerts(conf.keyStore(), conf.keyStorePassword(), conf.keyPassword(), conf.keyStoreType(), exceptionFactory)};
        } else if (conf.fallbackToSystemKeyStore()) {
            String keyStore = System.getProperty("javax.net.ssl.keyStore");
            String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword", conf.keyStorePassword());
            String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", conf.keyStoreType());
            if (keyStore != null) {
                try {
                    keyManager = new KeyManager[]{DefaultTlsSocketPlugin.loadClientCerts(keyStore, keyStorePassword, keyStorePassword, keyStoreType, exceptionFactory)};
                }
                catch (SQLException queryException) {
                    keyManager = null;
                    logger.error("Error loading key manager from system properties", queryException);
                }
            }
        }
        return keyManager;
    }

    @Override
    public void verify(String host, SSLSession session, long serverThreadId) throws SSLException {
        try {
            Certificate[] certs = session.getPeerCertificates();
            X509Certificate cert = (X509Certificate)certs[0];
            HostnameVerifier.verify(host, cert, serverThreadId);
        }
        catch (SSLException ex) {
            logger.info(ex.getMessage(), ex);
            throw ex;
        }
    }
}

