/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.hibernate.community.dialect.HANALegacyDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;

public class HANALegacyServerConfiguration {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(HANALegacyServerConfiguration.class);
    public static final int MAX_LOB_PREFETCH_SIZE_DEFAULT_VALUE = 1024;
    private final DatabaseVersion fullVersion;
    private final int maxLobPrefetchSize;

    public HANALegacyServerConfiguration(DatabaseVersion fullVersion) {
        this(fullVersion, 1024);
    }

    public HANALegacyServerConfiguration(DatabaseVersion fullVersion, int maxLobPrefetchSize) {
        this.fullVersion = fullVersion;
        this.maxLobPrefetchSize = maxLobPrefetchSize;
    }

    public DatabaseVersion getFullVersion() {
        return this.fullVersion;
    }

    public int getMaxLobPrefetchSize() {
        return this.maxLobPrefetchSize;
    }

    public static HANALegacyServerConfiguration fromDialectResolutionInfo(DialectResolutionInfo info) {
        Integer maxLobPrefetchSize = null;
        DatabaseMetaData databaseMetaData = info.getDatabaseMetadata();
        if (databaseMetaData != null) {
            try (Statement statement = databaseMetaData.getConnection().createStatement();
                 ResultSet rs = statement.executeQuery("SELECT TOP 1 VALUE,MAP(LAYER_NAME,'DEFAULT',1,'SYSTEM',2,'DATABASE',3,4) AS LAYER FROM SYS.M_INIFILE_CONTENTS WHERE FILE_NAME='indexserver.ini' AND SECTION='session' AND KEY='max_lob_prefetch_size' ORDER BY LAYER DESC");){
                if (rs.next()) {
                    maxLobPrefetchSize = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                LOG.debug((Object)"An error occurred while trying to determine the value of the HANA parameter indexserver.ini / session / max_lob_prefetch_size.", (Throwable)e);
            }
        }
        if (maxLobPrefetchSize == null) {
            maxLobPrefetchSize = ConfigurationHelper.getInt((String)"hibernate.dialect.hana.max_lob_prefetch_size", (Map)info.getConfigurationValues(), (int)1024);
        }
        return new HANALegacyServerConfiguration(HANALegacyServerConfiguration.staticDetermineDatabaseVersion(info), maxLobPrefetchSize);
    }

    static DatabaseVersion staticDetermineDatabaseVersion(DialectResolutionInfo info) {
        String versionString = info.getDatabaseVersion();
        int majorVersion = 1;
        int minorVersion = 0;
        int patchLevel = 0;
        if (versionString == null) {
            return HANALegacyDialect.DEFAULT_VERSION;
        }
        String[] components = StringHelper.split((String)".", (String)versionString);
        if (components.length >= 3) {
            try {
                majorVersion = Integer.parseInt(components[0]);
                minorVersion = Integer.parseInt(components[1]);
                patchLevel = Integer.parseInt(components[2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return DatabaseVersion.make((Integer)majorVersion, (Integer)minorVersion, (Integer)patchLevel);
    }
}

