/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.internal;

import org.hibernate.HibernateException;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.internal.ProxyVisitor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;

public abstract class ReattachVisitor
extends ProxyVisitor {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ReattachVisitor.class);
    private final Object ownerIdentifier;
    private final Object owner;

    public ReattachVisitor(EventSource session, Object ownerIdentifier, Object owner) {
        super(session);
        this.ownerIdentifier = ownerIdentifier;
        this.owner = owner;
    }

    final Object getOwnerIdentifier() {
        return this.ownerIdentifier;
    }

    final Object getOwner() {
        return this.owner;
    }

    @Override
    Object processComponent(Object component, CompositeType componentType) throws HibernateException {
        Type[] types = componentType.getSubtypes();
        if (component == null) {
            this.processValues(new Object[types.length], types);
        } else {
            super.processComponent(component, componentType);
        }
        return null;
    }

    void removeCollection(CollectionPersister role, Object collectionKey, EventSource source) throws HibernateException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Collection dereferenced while transient " + MessageHelper.collectionInfoString(role, this.ownerIdentifier, (SessionFactoryImplementor)source.getFactory()));
        }
        source.getActionQueue().addAction(new CollectionRemoveAction(this.owner, role, collectionKey, false, source));
    }

    final Object extractCollectionKeyFromOwner(CollectionPersister role) {
        CollectionType collectionType = role.getCollectionType();
        if (collectionType.useLHSPrimaryKey()) {
            return this.ownerIdentifier;
        }
        return role.getOwnerEntityPersister().getPropertyValue(this.owner, collectionType.getLHSPropertyName());
    }
}

