/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.condition;

import java.util.ArrayList;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.services.clientpolicy.condition.AbstractClientPolicyConditionProviderFactory;
import org.keycloak.services.clientpolicy.condition.ClientPolicyConditionProvider;
import org.keycloak.services.clientpolicy.condition.ClientUpdaterSourceGroupsCondition;

public class ClientUpdaterSourceGroupsConditionFactory
extends AbstractClientPolicyConditionProviderFactory {
    public static final String PROVIDER_ID = "client-updater-source-groups";
    public static final String GROUPS = "groups";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public ClientPolicyConditionProvider create(KeycloakSession session) {
        return new ClientUpdaterSourceGroupsCondition(session);
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "The condition checks the group of the entity who tries to create/update the client to determine whether the policy is applied.";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ClientUpdaterSourceGroupsConditionFactory.addCommonConfigProperties(configProperties);
        ProviderConfigProperty property = new ProviderConfigProperty(GROUPS, "client-updater-source-groups.label", "client-updater-source-groups.tooltip", "MultivaluedString", (Object)"topGroup");
        configProperties.add(property);
    }
}

