/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NoSuchElementException;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BigDecimalJavaType;
import org.hibernate.type.descriptor.java.BigIntegerJavaType;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.DoubleJavaType;
import org.hibernate.type.descriptor.java.FloatJavaType;
import org.hibernate.type.descriptor.java.IntegerJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.LongJavaType;
import org.hibernate.type.descriptor.java.ShortJavaType;
import org.hibernate.type.format.JsonDocumentItemType;
import org.hibernate.type.format.JsonDocumentReader;
import org.hibernate.type.format.StringJsonDocument;
import org.hibernate.type.format.StringJsonDocumentMarker;

public class StringJsonDocumentReader
extends StringJsonDocument
implements JsonDocumentReader {
    private static final char ESCAPE_CHAR = '\\';
    private final String jsonString;
    private final int limit;
    private int position;
    private int jsonValueStart;
    private int jsonValueEnd;

    public StringJsonDocumentReader(String json) {
        if (json == null) {
            throw new IllegalArgumentException("json cannot be null");
        }
        this.jsonString = json;
        this.position = 0;
        this.limit = this.jsonString.length();
        this.jsonValueStart = 0;
        this.jsonValueEnd = 0;
    }

    @Override
    public boolean hasNext() {
        return this.position < this.limit;
    }

    private void skipWhiteSpace() {
        while (this.position < this.limit) {
            if (!Character.isWhitespace(this.jsonString.charAt(this.position))) {
                return;
            }
            ++this.position;
        }
    }

    private void resetValueWindow() {
        this.jsonValueStart = 0;
        this.jsonValueEnd = 0;
    }

    private void moveStateMachine(StringJsonDocumentMarker marker) {
        StringJsonDocument.JsonProcessingState currentState = (StringJsonDocument.JsonProcessingState)((Object)this.processingStates.getCurrent());
        switch (marker) {
            case OBJECT_START: {
                if (currentState == StringJsonDocument.JsonProcessingState.STARTING_ARRAY) {
                    this.processingStates.push(StringJsonDocument.JsonProcessingState.ARRAY);
                }
                this.processingStates.push(StringJsonDocument.JsonProcessingState.STARTING_OBJECT);
                break;
            }
            case OBJECT_END: {
                assert (this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.OBJECT || this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.STARTING_OBJECT);
                if (this.processingStates.pop() != StringJsonDocument.JsonProcessingState.OBJECT) break;
                assert (this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.STARTING_OBJECT);
                this.processingStates.pop();
                break;
            }
            case ARRAY_START: {
                this.processingStates.push(StringJsonDocument.JsonProcessingState.STARTING_ARRAY);
                break;
            }
            case ARRAY_END: {
                assert (this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.ARRAY || this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.STARTING_ARRAY);
                if (this.processingStates.pop() != StringJsonDocument.JsonProcessingState.ARRAY) break;
                assert (this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.STARTING_ARRAY);
                this.processingStates.pop();
                break;
            }
            case SEPARATOR: {
                if (currentState != StringJsonDocument.JsonProcessingState.OBJECT) break;
                this.processingStates.push(StringJsonDocument.JsonProcessingState.OBJECT_KEY_NAME);
                break;
            }
            case KEY_VALUE_SEPARATOR: {
                assert (this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.OBJECT_KEY_NAME);
                this.processingStates.pop();
                assert (this.processingStates.getCurrent() == StringJsonDocument.JsonProcessingState.OBJECT);
                break;
            }
            case QUOTE: {
                if (currentState == StringJsonDocument.JsonProcessingState.STARTING_ARRAY) {
                    this.processingStates.push(StringJsonDocument.JsonProcessingState.ARRAY);
                }
                if (currentState != StringJsonDocument.JsonProcessingState.STARTING_OBJECT) break;
                this.processingStates.push(StringJsonDocument.JsonProcessingState.OBJECT);
                this.processingStates.push(StringJsonDocument.JsonProcessingState.OBJECT_KEY_NAME);
                break;
            }
            case OTHER: {
                if (currentState != StringJsonDocument.JsonProcessingState.STARTING_ARRAY) break;
                this.processingStates.push(StringJsonDocument.JsonProcessingState.ARRAY);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected JsonProcessingState " + String.valueOf((Object)marker));
            }
        }
    }

    @Override
    public JsonDocumentItemType next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("no more elements");
        }
        block20: while (this.hasNext()) {
            this.skipWhiteSpace();
            StringJsonDocumentMarker marker = StringJsonDocumentMarker.markerOf(this.jsonString.charAt(this.position++));
            this.moveStateMachine(marker);
            switch (marker) {
                case OBJECT_START: {
                    this.resetValueWindow();
                    return JsonDocumentItemType.OBJECT_START;
                }
                case OBJECT_END: {
                    this.resetValueWindow();
                    return JsonDocumentItemType.OBJECT_END;
                }
                case ARRAY_START: {
                    this.resetValueWindow();
                    return JsonDocumentItemType.ARRAY_START;
                }
                case ARRAY_END: {
                    this.resetValueWindow();
                    return JsonDocumentItemType.ARRAY_END;
                }
                case QUOTE: {
                    this.moveBufferPosition(-1);
                    this.consumeQuotedString();
                    switch ((StringJsonDocument.JsonProcessingState)((Object)this.processingStates.getCurrent())) {
                        case STARTING_ARRAY: {
                            return JsonDocumentItemType.VALUE;
                        }
                        case ARRAY: {
                            return JsonDocumentItemType.VALUE;
                        }
                        case STARTING_OBJECT: {
                            return JsonDocumentItemType.VALUE_KEY;
                        }
                        case OBJECT: {
                            return JsonDocumentItemType.VALUE;
                        }
                        case OBJECT_KEY_NAME: {
                            return JsonDocumentItemType.VALUE_KEY;
                        }
                    }
                    throw new IllegalStateException("unexpected quote read in current processing state " + String.valueOf(this.processingStates.getCurrent()));
                }
                case KEY_VALUE_SEPARATOR: {
                    continue block20;
                }
                case SEPARATOR: {
                    continue block20;
                }
                case OTHER: {
                    this.moveBufferPosition(-1);
                    int valueSize = this.consumeNonStringValue();
                    if (valueSize == -1) {
                        throw new IllegalStateException("Unrecognized marker: " + String.valueOf((Object)StringJsonDocumentMarker.markerOf(this.jsonString.charAt(this.position))));
                    }
                    switch ((StringJsonDocument.JsonProcessingState)((Object)this.processingStates.getCurrent())) {
                        case ARRAY: 
                        case OBJECT: {
                            return this.getUnquotedValueType(this.jsonString.charAt(this.jsonValueStart));
                        }
                    }
                    throw new IllegalStateException("unexpected read [" + this.jsonString.substring(this.jsonValueStart, this.jsonValueEnd) + "] in current processing state " + String.valueOf(this.processingStates.getCurrent()));
                }
            }
            throw new IllegalStateException("unexpected marker [" + String.valueOf((Object)marker) + "] at position " + this.position);
        }
        throw new IllegalStateException("unexpected end of JSON [" + this.jsonString.substring(this.jsonValueStart, this.jsonValueEnd) + "] in current processing state " + String.valueOf(this.processingStates.getCurrent()));
    }

    private JsonDocumentItemType getUnquotedValueType(char jsonValueChar) {
        switch (jsonValueChar) {
            case 't': {
                return JsonDocumentItemType.BOOLEAN_VALUE;
            }
            case 'f': {
                return JsonDocumentItemType.BOOLEAN_VALUE;
            }
            case 'n': {
                return JsonDocumentItemType.NULL_VALUE;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return JsonDocumentItemType.NUMERIC_VALUE;
            }
        }
        return JsonDocumentItemType.VALUE;
    }

    private void moveBufferPosition(int shift) {
        this.position += shift;
    }

    private void moveTo(char character) throws IllegalStateException {
        for (int pointer = this.position; pointer < this.limit; ++pointer) {
            char c = this.jsonString.charAt(pointer);
            if (c == character) {
                this.position = pointer == this.position ? this.position : pointer - 1;
                return;
            }
            if (!Character.isWhitespace(c)) break;
        }
        throw new IllegalStateException("character [" + character + "] is not the next non-blank character");
    }

    private int nextQuote() {
        for (int pointer = this.position; pointer < this.limit; ++pointer) {
            char c = this.jsonString.charAt(pointer);
            if (c == '\\') {
                ++pointer;
                continue;
            }
            if (c != '\"') continue;
            return pointer;
        }
        return -1;
    }

    private int consumeNonStringValue() {
        int newViewLimit = 0;
        boolean allGood = false;
        for (int i = this.position; i < this.limit; ++i) {
            char c = this.jsonString.charAt(i);
            if (StringJsonDocumentMarker.markerOf(c) == StringJsonDocumentMarker.OTHER && !Character.isWhitespace(c)) continue;
            allGood = true;
            newViewLimit = i;
            break;
        }
        if (allGood) {
            this.jsonValueEnd = newViewLimit;
            this.jsonValueStart = this.position;
            this.position = newViewLimit;
        }
        return allGood ? this.jsonValueEnd - this.jsonValueStart : -1;
    }

    private void consumeQuotedString() {
        this.moveTo(StringJsonDocumentMarker.QUOTE.getMarkerCharacter());
        ++this.position;
        int endingQuote = this.nextQuote();
        if (endingQuote == -1) {
            throw new IllegalStateException("Can't find ending quote of key name");
        }
        this.jsonValueEnd = endingQuote;
        this.jsonValueStart = this.position;
        this.position = endingQuote + 1;
    }

    private void ensureValueState() throws IllegalStateException {
        if (this.processingStates.getCurrent() != StringJsonDocument.JsonProcessingState.OBJECT && this.processingStates.getCurrent() != StringJsonDocument.JsonProcessingState.ARRAY) {
            throw new IllegalStateException("unexpected processing state: " + String.valueOf(this.processingStates.getCurrent()));
        }
    }

    private void ensureAvailableValue() throws IllegalStateException {
        if (this.jsonValueEnd == 0) {
            throw new IllegalStateException("No available value");
        }
    }

    @Override
    public String getObjectKeyName() {
        if (this.processingStates.getCurrent() != StringJsonDocument.JsonProcessingState.OBJECT_KEY_NAME) {
            throw new IllegalStateException("unexpected processing state: " + String.valueOf(this.processingStates.getCurrent()));
        }
        this.ensureAvailableValue();
        return this.jsonString.substring(this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public String getStringValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        if (this.currentValueHasEscape()) {
            return StringJsonDocumentReader.unescape(this.jsonString, this.jsonValueStart, this.jsonValueEnd);
        }
        return this.jsonString.substring(this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        return (BigDecimal)BigDecimalJavaType.INSTANCE.fromEncodedString(this.jsonString, this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        return (BigInteger)BigIntegerJavaType.INSTANCE.fromEncodedString(this.jsonString, this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public double getDoubleValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        return (Double)DoubleJavaType.INSTANCE.fromEncodedString(this.jsonString, this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public float getFloatValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        return ((Float)FloatJavaType.INSTANCE.fromEncodedString(this.jsonString, this.jsonValueStart, this.jsonValueEnd)).floatValue();
    }

    @Override
    public long getLongValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        return (Long)LongJavaType.INSTANCE.fromEncodedString(this.jsonString, this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public int getIntegerValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        return (Integer)IntegerJavaType.INSTANCE.fromEncodedString(this.jsonString, this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public short getShortValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        return (Short)ShortJavaType.INSTANCE.fromEncodedString(this.jsonString, this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public byte getByteValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        return (Byte)ByteJavaType.INSTANCE.fromEncodedString(this.jsonString, this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public boolean getBooleanValue() {
        this.ensureValueState();
        this.ensureAvailableValue();
        return BooleanJavaType.INSTANCE.fromEncodedString(this.jsonString, this.jsonValueStart, this.jsonValueEnd);
    }

    @Override
    public <T> T getValue(JavaType<T> javaType, WrapperOptions options) {
        return javaType.fromEncodedString(this.jsonString.subSequence(this.jsonValueStart, this.jsonValueEnd));
    }

    private boolean currentValueHasEscape() {
        for (int i = this.jsonValueStart; i < this.jsonValueEnd; ++i) {
            if (this.jsonString.charAt(i) != '\\') continue;
            return true;
        }
        return false;
    }

    private static String unescape(String string, int start, int end) {
        StringBuilder sb = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                char cNext = string.charAt(++i);
                switch (cNext) {
                    case '\"': 
                    case '/': 
                    case '\\': {
                        sb.append(cNext);
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'u': {
                        sb.append((char)Integer.parseInt(string, i + 1, i + 5, 16));
                        i += 4;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

