/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AdjustableJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.type.descriptor.jdbc.XmlArrayJdbcType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class XmlAsStringArrayJdbcType
extends XmlArrayJdbcType
implements AdjustableJdbcType {
    private final boolean nationalized;
    private final int ddlTypeCode;

    public XmlAsStringArrayJdbcType(JdbcType elementJdbcType) {
        this(elementJdbcType, 4001);
    }

    protected XmlAsStringArrayJdbcType(JdbcType elementJdbcType, int ddlTypeCode) {
        super(elementJdbcType);
        this.ddlTypeCode = ddlTypeCode;
        this.nationalized = ddlTypeCode == 4002 || ddlTypeCode == 2011;
    }

    @Override
    public int getJdbcTypeCode() {
        return this.nationalized ? -9 : 12;
    }

    @Override
    public int getDdlTypeCode() {
        return this.ddlTypeCode;
    }

    @Override
    public String toString() {
        return "XmlArrayAsStringJdbcType";
    }

    @Override
    public JdbcType resolveIndicatedType(JdbcTypeIndicators indicators, JavaType<?> domainJtd) {
        if (this.needsLob(indicators)) {
            return indicators.isNationalized() ? new XmlAsStringArrayJdbcType(this.getElementJdbcType(), 2011) : new XmlAsStringArrayJdbcType(this.getElementJdbcType(), 2005);
        }
        return indicators.isNationalized() ? new XmlAsStringArrayJdbcType(this.getElementJdbcType(), 4002) : new XmlAsStringArrayJdbcType(this.getElementJdbcType(), 4001);
    }

    protected boolean needsLob(JdbcTypeIndicators indicators) {
        long maxLength;
        Dialect dialect = indicators.getDialect();
        long length = indicators.getColumnLength();
        long l = maxLength = indicators.isNationalized() ? (long)dialect.getMaxNVarcharLength() : (long)dialect.getMaxVarcharLength();
        if (length > maxLength) {
            return true;
        }
        DdlTypeRegistry ddlTypeRegistry = indicators.getTypeConfiguration().getDdlTypeRegistry();
        String typeName = ddlTypeRegistry.getTypeName(this.getDdlTypeCode(), dialect);
        return typeName.equals(ddlTypeRegistry.getTypeName(2005, dialect)) || typeName.equals(ddlTypeRegistry.getTypeName(2011, dialect));
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            private XmlAsStringArrayJdbcType getXmlAsStringArrayJdbcType() {
                return (XmlAsStringArrayJdbcType)this.getJdbcType();
            }

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                XmlAsStringArrayJdbcType jdbcType = this.getXmlAsStringArrayJdbcType();
                String xml = jdbcType.toString(value, this.getJavaType(), options);
                if (jdbcType.nationalized && options.getDialect().supportsNationalizedMethods()) {
                    st.setNString(index, xml);
                } else {
                    st.setString(index, xml);
                }
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                XmlAsStringArrayJdbcType jdbcType = this.getXmlAsStringArrayJdbcType();
                String xml = jdbcType.toString(value, this.getJavaType(), options);
                if (jdbcType.nationalized && options.getDialect().supportsNationalizedMethods()) {
                    st.setNString(name, xml);
                } else {
                    st.setString(name, xml);
                }
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            private XmlAsStringArrayJdbcType getXmlAsStringArrayJdbcType() {
                return (XmlAsStringArrayJdbcType)this.getJdbcType();
            }

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                XmlAsStringArrayJdbcType jdbcType = this.getXmlAsStringArrayJdbcType();
                String value = jdbcType.nationalized && options.getDialect().supportsNationalizedMethods() ? rs.getNString(paramIndex) : rs.getString(paramIndex);
                return jdbcType.fromString(value, this.getJavaType(), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                XmlAsStringArrayJdbcType jdbcType = this.getXmlAsStringArrayJdbcType();
                String value = jdbcType.nationalized && options.getDialect().supportsNationalizedMethods() ? statement.getNString(index) : statement.getString(index);
                return jdbcType.fromString(value, this.getJavaType(), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                XmlAsStringArrayJdbcType jdbcType = this.getXmlAsStringArrayJdbcType();
                String value = jdbcType.nationalized && options.getDialect().supportsNationalizedMethods() ? statement.getNString(name) : statement.getString(name);
                return jdbcType.fromString(value, this.getJavaType(), options);
            }
        };
    }
}

