/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.EntityType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.MappingContext;
import org.hibernate.type.spi.TypeConfiguration;

public class ManyToOneType
extends EntityType {
    private final String propertyName;
    private final boolean ignoreNotFound;
    private final boolean isLogicalOneToOne;

    public ManyToOneType(TypeConfiguration typeConfiguration, String referencedEntityName) {
        this(typeConfiguration, referencedEntityName, false);
    }

    public ManyToOneType(TypeConfiguration typeConfiguration, String referencedEntityName, boolean lazy) {
        this(typeConfiguration, referencedEntityName, true, null, null, lazy, true, false, false);
    }

    public ManyToOneType(TypeConfiguration typeConfiguration, String referencedEntityName, boolean referenceToPrimaryKey, String uniqueKeyPropertyName, String propertyName, boolean lazy, boolean unwrapProxy, boolean ignoreNotFound, boolean isLogicalOneToOne) {
        super(typeConfiguration, referencedEntityName, referenceToPrimaryKey, uniqueKeyPropertyName, !lazy, unwrapProxy);
        this.propertyName = propertyName;
        this.ignoreNotFound = ignoreNotFound;
        this.isLogicalOneToOne = isLogicalOneToOne;
    }

    public ManyToOneType(ManyToOneType original, String superTypeEntityName) {
        super(original, superTypeEntityName);
        this.propertyName = original.propertyName;
        this.ignoreNotFound = original.ignoreNotFound;
        this.isLogicalOneToOne = original.isLogicalOneToOne;
    }

    public ManyToOneType(String name, TypeConfiguration typeConfiguration) {
        this(typeConfiguration, name);
    }

    @Override
    public boolean isNullable() {
        return this.ignoreNotFound;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public boolean isAlwaysDirtyChecked() {
        return true;
    }

    @Override
    public boolean isOneToOne() {
        return false;
    }

    @Override
    public boolean isLogicalOneToOne() {
        return this.isLogicalOneToOne;
    }

    @Override
    public int getColumnSpan(MappingContext mapping) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mapping).getColumnSpan(mapping);
    }

    @Override
    public int[] getSqlTypeCodes(MappingContext mappingContext) throws MappingException {
        return this.requireIdentifierOrUniqueKeyType(mappingContext).getSqlTypeCodes(mappingContext);
    }

    @Override
    public ForeignKeyDirection getForeignKeyDirection() {
        return ForeignKeyDirection.FROM_PARENT;
    }

    private void scheduleBatchLoadIfNeeded(Object id, SharedSessionContractImplementor session) throws MappingException {
        if (this.uniqueKeyPropertyName == null && id != null) {
            EntityPersister persister = this.getAssociatedEntityPersister(session.getFactory());
            if (session.getLoadQueryInfluencers().effectivelyBatchLoadable(persister)) {
                EntityKey entityKey = session.generateEntityKey(id, persister);
                PersistenceContext persistenceContext = session.getPersistenceContextInternal();
                if (!persistenceContext.containsEntity(entityKey)) {
                    persistenceContext.getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
                }
            }
        }
    }

    @Override
    public boolean useLHSPrimaryKey() {
        return false;
    }

    @Override
    public boolean isModified(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        if (current == null) {
            return old != null;
        }
        if (old == null) {
            return true;
        }
        return this.getIdentifierOrUniqueKeyType(session.getFactory().getRuntimeMetamodels()).isDirty(old, this.getIdentifierEvenIfTransient(current, session), session);
    }

    @Override
    public Serializable disassemble(Object value, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        Object id = ForeignKeys.getEntityIdentifierIfNotUnsaved(this.getAssociatedEntityName(), value, session);
        this.checkIdNotNull(id);
        return this.getIdentifierType(session).disassemble(id, session, owner);
    }

    @Override
    public Serializable disassemble(Object value, SessionFactoryImplementor sessionFactory) throws HibernateException {
        if (value == null) {
            return null;
        }
        Object id = this.getIdentifier(value, sessionFactory);
        this.checkIdNotNull(id);
        return this.getIdentifierType(sessionFactory.getRuntimeMetamodels()).disassemble(id, sessionFactory);
    }

    private void checkIdNotNull(Object id) {
        if (id == null) {
            throw new AssertionFailure("cannot cache a reference to an object with a null id: " + this.getAssociatedEntityName());
        }
    }

    @Override
    public Object assemble(Serializable oid, SharedSessionContractImplementor session, Object owner) throws HibernateException {
        Object id = this.assembleId(oid, session);
        return id == null ? null : this.resolveIdentifier(id, session);
    }

    private Object assembleId(Serializable oid, SharedSessionContractImplementor session) {
        return this.getIdentifierType(session).assemble(oid, session, null);
    }

    @Override
    public void beforeAssemble(Serializable oid, SharedSessionContractImplementor session) {
        this.scheduleBatchLoadIfNeeded(this.assembleId(oid, session), session);
    }

    @Override
    public boolean[] toColumnNullness(Object value, MappingContext mapping) {
        boolean[] result = new boolean[this.getColumnSpan(mapping)];
        if (value != null) {
            Arrays.fill(result, true);
        }
        return result;
    }

    @Override
    public boolean isDirty(Object old, Object current, SharedSessionContractImplementor session) throws HibernateException {
        if (this.isSame(old, current)) {
            return false;
        }
        Object oldid = this.getIdentifierEvenIfTransient(old, session);
        Object newid = this.getIdentifierEvenIfTransient(current, session);
        return this.getIdentifierOrUniqueKeyType(session.getFactory().getRuntimeMetamodels()).isDirty(oldid, newid, session);
    }

    @Override
    public boolean isDirty(Object old, Object current, boolean[] checkable, SharedSessionContractImplementor session) throws HibernateException {
        if (this.isAlwaysDirtyChecked()) {
            return this.isDirty(old, current, session);
        }
        if (this.isSame(old, current)) {
            return false;
        }
        Object oldid = this.getIdentifierEvenIfTransient(old, session);
        Object newid = this.getIdentifierEvenIfTransient(current, session);
        return this.getIdentifierOrUniqueKeyType(session.getFactory().getRuntimeMetamodels()).isDirty(oldid, newid, checkable, session);
    }
}

