/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.jdbc.internal.AbstractResultSetAccess;

public class DirectResultSetAccess
extends AbstractResultSetAccess {
    private final PreparedStatement resultSetSource;
    private final ResultSet resultSet;

    public DirectResultSetAccess(SharedSessionContractImplementor persistenceContext, PreparedStatement resultSetSource, ResultSet resultSet) {
        super(persistenceContext);
        this.resultSetSource = resultSetSource;
        this.resultSet = resultSet;
        persistenceContext.getJdbcCoordinator().getLogicalConnection().getResourceRegistry().register(resultSet, resultSetSource);
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    protected SessionFactoryImplementor getFactory() {
        return this.getPersistenceContext().getFactory();
    }

    @Override
    public void release() {
        this.getPersistenceContext().getJdbcCoordinator().getLogicalConnection().getResourceRegistry().release(this.resultSet, this.resultSetSource);
    }
}

