/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph;

import java.util.function.Function;
import org.hibernate.Incubating;
import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.AssociationKey;
import org.hibernate.metamodel.mapping.EmbeddableDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.results.internal.ResultsHelper;
import org.hibernate.spi.EntityIdentifierNavigablePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;

@Incubating
public interface DomainResultCreationState {
    default public boolean forceIdentifierSelection() {
        return true;
    }

    public SqlAstCreationState getSqlAstCreationState();

    default public SqlAliasBaseManager getSqlAliasBaseManager() {
        return (SqlAliasBaseManager)this.getSqlAstCreationState().getSqlAliasBaseGenerator();
    }

    default public boolean registerVisitedAssociationKey(AssociationKey circularityKey) {
        return false;
    }

    default public void removeVisitedAssociationKey(AssociationKey circularityKey) {
    }

    default public boolean isAssociationKeyVisited(AssociationKey circularityKey) {
        return false;
    }

    default public boolean isRegisteringVisitedAssociationKeys() {
        return false;
    }

    public ModelPart resolveModelPart(NavigablePath var1);

    default public Fetch visitIdentifierFetch(EntityResultGraphNode fetchParent) {
        EntityIdentifierMapping identifierMapping = fetchParent.getReferencedMappingContainer().getIdentifierMapping();
        return fetchParent.generateFetchableFetch(identifierMapping, new EntityIdentifierNavigablePath(fetchParent.getNavigablePath(), ResultsHelper.attributeName(identifierMapping)), FetchTiming.IMMEDIATE, true, null, this);
    }

    default public BasicFetch<?> visitDiscriminatorFetch(EntityResultGraphNode fetchParent) {
        EntityMappingType entityDescriptor = fetchParent.getEntityValuedModelPart().getEntityMappingType();
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        if (discriminatorMapping != null && entityDescriptor.hasSubclasses()) {
            return discriminatorMapping.generateFetch(fetchParent, fetchParent.getNavigablePath().append("{discriminator}"), FetchTiming.IMMEDIATE, true, null, this);
        }
        return null;
    }

    default public BasicFetch<?> visitEmbeddableDiscriminatorFetch(EmbeddableResultGraphNode fetchParent, boolean nested) {
        EmbeddableMappingType embeddableType = fetchParent.getReferencedMappingType();
        EmbeddableDiscriminatorMapping discriminatorMapping = embeddableType.getDiscriminatorMapping();
        if (discriminatorMapping != null) {
            Function<FetchParent, BasicFetch> fetchSupplier = fp -> discriminatorMapping.generateFetch((FetchParent)fp, fp.getNavigablePath().append("{discriminator}"), FetchTiming.IMMEDIATE, true, null, this);
            if (nested) {
                return this.withNestedFetchParent(fetchParent, fetchSupplier);
            }
            return fetchSupplier.apply(fetchParent);
        }
        return null;
    }

    public ImmutableFetchList visitFetches(FetchParent var1);

    default public ImmutableFetchList visitNestedFetches(FetchParent fetchParent) {
        return this.withNestedFetchParent(fetchParent, this::visitFetches);
    }

    public <R> R withNestedFetchParent(FetchParent var1, Function<FetchParent, R> var2);

    public boolean isResolvingCircularFetch();

    public void setResolvingCircularFetch(boolean var1);

    public ForeignKeyDescriptor.Nature getCurrentlyResolvingForeignKeyPart();

    public void setCurrentlyResolvingForeignKeyPart(ForeignKeyDescriptor.Nature var1);
}

