/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.type.internal.BindingTypeHelper;
import org.hibernate.type.spi.TypeConfiguration;

public interface JdbcParameterBindings {
    public static final JdbcParameterBindings NO_BINDINGS = new JdbcParameterBindings(){

        @Override
        public void addBinding(JdbcParameter parameter, JdbcParameterBinding binding) {
        }

        @Override
        public Collection<JdbcParameterBinding> getBindings() {
            return Collections.emptyList();
        }

        @Override
        public JdbcParameterBinding getBinding(JdbcParameter parameter) {
            return null;
        }

        @Override
        public void visitBindings(BiConsumer<JdbcParameter, JdbcParameterBinding> action) {
        }
    };

    public void addBinding(JdbcParameter var1, JdbcParameterBinding var2);

    public Collection<JdbcParameterBinding> getBindings();

    public JdbcParameterBinding getBinding(JdbcParameter var1);

    public void visitBindings(BiConsumer<JdbcParameter, JdbcParameterBinding> var1);

    default public int registerParametersForEachJdbcValue(Object value, Bindable bindable, JdbcParametersList jdbcParameters, SharedSessionContractImplementor session) {
        return this.registerParametersForEachJdbcValue(value, 0, bindable, jdbcParameters, session);
    }

    default public int registerParametersForEachJdbcValue(Object value, int offset, Bindable bindable, JdbcParametersList jdbcParameters, SharedSessionContractImplementor session) {
        Object object;
        if (bindable instanceof BasicValuedMapping) {
            BasicValuedMapping basicValuedMapping = (BasicValuedMapping)bindable;
            object = basicValuedMapping.getJdbcMapping().getMappedJavaType().wrap(value, session);
        } else {
            object = value;
        }
        return bindable.forEachJdbcValue(object, offset, jdbcParameters, session.getFactory().getTypeConfiguration(), this::createAndAddBinding, session);
    }

    private void createAndAddBinding(int selectionIndex, JdbcParametersList params, TypeConfiguration typeConfiguration, Object jdbcValue, JdbcMapping type) {
        this.addBinding(params.get(selectionIndex), new JdbcParameterBindingImpl(BindingTypeHelper.resolveBindType(jdbcValue, type, typeConfiguration), jdbcValue));
    }
}

