/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sql.internal.NativeQueryImpl;
import org.hibernate.query.sql.spi.ParameterOccurrence;
import org.hibernate.sql.ast.tree.expression.JdbcParameter;
import org.hibernate.sql.exec.internal.JdbcParameterBindingImpl;
import org.hibernate.sql.exec.internal.JdbcParameterImpl;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.BasicTypeReference;
import org.hibernate.type.BindableType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;

public class JdbcParameterBindingsImpl
implements JdbcParameterBindings {
    private Map<JdbcParameter, JdbcParameterBinding> bindingMap;

    public JdbcParameterBindingsImpl(int expectedParameterCount) {
        if (expectedParameterCount > 0) {
            this.bindingMap = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>(expectedParameterCount);
        }
    }

    public JdbcParameterBindingsImpl(QueryParameterBindings queryParameterBindings, List<ParameterOccurrence> parameterOccurrences, List<JdbcParameterBinder> jdbcParameterBinders, SessionFactoryImplementor factory) {
        if (!parameterOccurrences.isEmpty()) {
            this.bindingMap = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>(parameterOccurrences.size());
            boolean paddingEnabled = factory.getSessionFactoryOptions().inClauseParameterPaddingEnabled();
            int inExprLimit = factory.getJdbcServices().getDialect().getParameterCountLimit();
            for (ParameterOccurrence occurrence : parameterOccurrences) {
                BasicValueConverter<?, ?> valueConverter;
                QueryParameterBinding<?> binding;
                QueryParameterImplementor<?> param = occurrence.parameter();
                JdbcMapping jdbcMapping = this.jdbcMapping(factory, param, binding = queryParameterBindings.getBinding(param));
                BasicValueConverter<?, ?> basicValueConverter = valueConverter = jdbcMapping == null ? null : jdbcMapping.getValueConverter();
                if (binding.isMultiValued()) {
                    JdbcParameterImpl jdbcParameter;
                    JdbcParameterImpl jdbcParameter2;
                    Collection<?> bindValues = binding.getBindValues();
                    int bindValueCount = bindValues.size();
                    int bindValueMaxCount = NativeQueryImpl.determineBindValueMaxCount(paddingEnabled, inExprLimit, bindValueCount);
                    Object lastBindValue = null;
                    if (valueConverter != null) {
                        for (Object bindValue : bindValues) {
                            jdbcParameter2 = new JdbcParameterImpl(jdbcMapping);
                            jdbcParameterBinders.add(jdbcParameter2);
                            lastBindValue = valueConverter.toRelationalValue(bindValue);
                            this.addBinding(jdbcParameter2, new JdbcParameterBindingImpl(jdbcMapping, lastBindValue));
                        }
                        if (bindValueMaxCount == bindValueCount) continue;
                        for (int i = bindValueCount; i < bindValueMaxCount; ++i) {
                            jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                            jdbcParameterBinders.add(jdbcParameter);
                            this.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, lastBindValue));
                        }
                        continue;
                    }
                    for (Object bindValue : bindValues) {
                        jdbcParameter2 = new JdbcParameterImpl(jdbcMapping);
                        jdbcParameterBinders.add(jdbcParameter2);
                        this.addBinding(jdbcParameter2, new JdbcParameterBindingImpl(jdbcMapping, bindValue));
                        lastBindValue = bindValue;
                    }
                    if (bindValueMaxCount == bindValueCount) continue;
                    for (int i = bindValueCount; i < bindValueMaxCount; ++i) {
                        jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                        jdbcParameterBinders.add(jdbcParameter);
                        this.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, lastBindValue));
                    }
                    continue;
                }
                Object bindValue = valueConverter != null && binding.getBindValue() != null ? valueConverter.toRelationalValue(binding.getBindValue()) : binding.getBindValue();
                JdbcParameterImpl jdbcParameter = new JdbcParameterImpl(jdbcMapping);
                jdbcParameterBinders.add(jdbcParameter);
                this.addBinding(jdbcParameter, new JdbcParameterBindingImpl(jdbcMapping, bindValue));
            }
        }
    }

    private JdbcMapping jdbcMapping(SessionFactoryImplementor factory, QueryParameterImplementor<?> param, QueryParameterBinding<?> binding) {
        BindableType<?> type = this.determineParamType(param, binding);
        if (type == null) {
            return factory.getTypeConfiguration().getBasicTypeForJavaType(Object.class);
        }
        if (type instanceof BasicTypeReference) {
            BasicTypeReference basicTypeReference = (BasicTypeReference)type;
            return factory.getTypeConfiguration().getBasicTypeRegistry().resolve(basicTypeReference);
        }
        if (type instanceof BasicValuedMapping) {
            BasicValuedMapping basicValuedMapping = (BasicValuedMapping)((Object)type);
            return basicValuedMapping.getJdbcMapping();
        }
        throw new IllegalArgumentException("Could not resolve NativeQuery parameter type : `" + String.valueOf(param) + "`");
    }

    private BindableType<?> determineParamType(QueryParameterImplementor<?> param, QueryParameterBinding<?> binding) {
        BindableType<?> type = binding.getBindType();
        return type == null ? param.getHibernateType() : type;
    }

    @Override
    public void addBinding(JdbcParameter parameter, JdbcParameterBinding binding) {
        if (this.bindingMap == null) {
            this.bindingMap = new IdentityHashMap<JdbcParameter, JdbcParameterBinding>();
        }
        this.bindingMap.put(parameter, binding);
    }

    @Override
    public Collection<JdbcParameterBinding> getBindings() {
        return this.bindingMap == null ? Collections.emptyList() : this.bindingMap.values();
    }

    @Override
    public JdbcParameterBinding getBinding(JdbcParameter parameter) {
        return this.bindingMap == null ? null : this.bindingMap.get(parameter);
    }

    @Override
    public void visitBindings(BiConsumer<JdbcParameter, JdbcParameterBinding> action) {
        if (this.bindingMap != null) {
            for (Map.Entry<JdbcParameter, JdbcParameterBinding> entry : this.bindingMap.entrySet()) {
                action.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public void clear() {
        if (this.bindingMap != null) {
            this.bindingMap.clear();
        }
    }
}

