/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.resource.jdbc.internal;

import java.lang.invoke.MethodHandles;
import java.sql.ResultSet;
import java.sql.Statement;
import org.hibernate.Internal;
import org.hibernate.internal.log.SubSystemLogging;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.ValidIdRange;

@SubSystemLogging(name="org.hibernate.orm.resource.registry", description="Logging related to use of ResourceRegistry")
@Internal
@MessageLogger(projectCode="HHH")
@ValidIdRange(min=10002501, max=10003000)
public interface ResourceRegistryLogger
extends BasicLogger {
    public static final String LOGGER_NAME = "org.hibernate.orm.resource.registry";
    public static final ResourceRegistryLogger RESOURCE_REGISTRY_LOGGER = (ResourceRegistryLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), ResourceRegistryLogger.class, (String)"org.hibernate.orm.resource.registry");

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Releasing registered JDBC resources", id=10002501)
    public void releasingResources();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Registering statement [%s]", id=10002502)
    public void registeringStatement(Statement var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Releasing statement [%s]", id=10002503)
    public void releasingStatement(Statement var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Releasing result set [%s]", id=10002504)
    public void releasingResultSet(ResultSet var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Closing result set [%s]", id=10002505)
    public void closingResultSet(ResultSet var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Closing prepared statement [%s]", id=10002506)
    public void closingPreparedStatement(Statement var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Registering result set [%s]", id=10002507)
    public void registeringResultSet(ResultSet var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Unable to release JDBC statement [%s]", id=10002508)
    public void unableToReleaseStatement(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Unable to release JDBC result set [%s]", id=10002509)
    public void unableToReleaseResultSet(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Exception clearing maxRows or queryTimeout for JDBC Statement [%s]", id=10002510)
    public void exceptionClearingMaxRowsOrQueryTimeout(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Unable to free '%s' reference [%s]", id=10002511)
    public void unableToFreeLob(String var1, String var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Statement associated with ResultSet was not registered", id=10002514)
    public void unregisteredStatement();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="ResultSet had no statement associated with it, but was not yet registered", id=10002515)
    public void unregisteredResultSetWithoutStatement();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Request to release '%s', but none have ever been registered", id=10002516)
    public void noRegisteredLobs(String var1);
}

