/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.Objects;
import org.hibernate.query.PathException;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmEntityDomainType;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedEntityValuedSimplePath<T, S extends T>
extends SqmEntityValuedSimplePath<S>
implements SqmSimplePath<S>,
SqmTreatedPath<T, S> {
    private final SqmEntityDomainType<S> treatTarget;
    private final SqmPath<T> wrappedPath;

    public SqmTreatedEntityValuedSimplePath(SqmPluralValuedSimplePath<T> wrappedPath, SqmEntityDomainType<S> treatTarget, NodeBuilder nodeBuilder) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName()), wrappedPath.getReferencedPathSource(), (SqmPath<?>)wrappedPath.getLhs(), nodeBuilder);
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    public SqmTreatedEntityValuedSimplePath(SqmPath<T> wrappedPath, SqmEntityDomainType<S> treatTarget, NodeBuilder nodeBuilder) {
        super(wrappedPath.getNavigablePath().treatAs(treatTarget.getHibernateEntityName()), wrappedPath.getReferencedPathSource(), (SqmPath<?>)wrappedPath.getLhs(), nodeBuilder);
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedEntityValuedSimplePath(NavigablePath navigablePath, SqmPath<T> wrappedPath, SqmEntityDomainType<S> treatTarget, NodeBuilder nodeBuilder) {
        super(navigablePath, wrappedPath.getReferencedPathSource(), (SqmPath<?>)wrappedPath.getLhs(), nodeBuilder);
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedEntityValuedSimplePath<T, S> copy(SqmCopyContext context) {
        SqmTreatedEntityValuedSimplePath existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedEntityValuedSimplePath<T, S> path = context.registerCopy(this, new SqmTreatedEntityValuedSimplePath<T, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.getTreatTarget(), (NodeBuilder)this.nodeBuilder()));
        this.copyTo(path, context);
        return path;
    }

    @Override
    public SqmEntityDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmPath<T> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public SqmEntityDomainType<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public <S1 extends S> SqmTreatedEntityValuedSimplePath<S, S1> treatAs(Class<S1> treatJavaType) throws PathException {
        return super.treatAs(treatJavaType);
    }

    @Override
    public SqmPath<?> get(String attributeName) {
        return this.resolvePath(attributeName, this.treatTarget.getSubPathSource(attributeName));
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitTreatedPath(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("treat(");
        this.wrappedPath.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.treatTarget.getName());
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmTreatedEntityValuedSimplePath)) return false;
        SqmTreatedEntityValuedSimplePath that = (SqmTreatedEntityValuedSimplePath)object;
        if (!Objects.equals(this.getExplicitAlias(), that.getExplicitAlias())) return false;
        if (!Objects.equals(this.treatTarget.getTypeName(), that.treatTarget.getTypeName())) return false;
        if (!Objects.equals(this.wrappedPath.getNavigablePath(), that.wrappedPath.getNavigablePath())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.treatTarget.getTypeName(), this.wrappedPath.getNavigablePath());
    }
}

