/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.Objects;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.IdentifiableDomainType;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.TreatException;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedPath;
import org.hibernate.spi.NavigablePath;

public class SqmFkExpression<T>
extends AbstractSqmPath<T> {
    public SqmFkExpression(SqmPath<?> toOnePath) {
        this(toOnePath.getNavigablePath().append("{fk}"), toOnePath);
    }

    private SqmFkExpression(NavigablePath navigablePath, SqmPath<?> toOnePath) {
        super(navigablePath, (SqmPathSource)SqmFkExpression.pathDomainType(toOnePath).getIdentifierDescriptor(), toOnePath, toOnePath.nodeBuilder());
    }

    private static IdentifiableDomainType<?> pathDomainType(SqmPath<?> toOnePath) {
        DomainType domainType = toOnePath.getReferencedPathSource().getPathType();
        if (domainType instanceof IdentifiableDomainType) {
            IdentifiableDomainType identifiableDomainType = (IdentifiableDomainType)domainType;
            return identifiableDomainType;
        }
        throw new IllegalArgumentException("Invalid path provided to 'fk()' function: " + String.valueOf(toOnePath.getNavigablePath()));
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitFkExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("fk(");
        this.getLhs().appendHqlString(hql, context);
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmFkExpression)) return false;
        SqmFkExpression that = (SqmFkExpression)object;
        if (!Objects.equals(this.getExplicitAlias(), that.getExplicitAlias())) return false;
        if (!Objects.equals(this.getLhs(), that.getLhs())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.getLhs().hashCode();
    }

    @Override
    public SqmFkExpression<T> copy(SqmCopyContext context) {
        SqmFkExpression existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmEntityValuedSimplePath lhsCopy = (SqmEntityValuedSimplePath)this.getLhs().copy(context);
        return context.registerCopy(this, new SqmFkExpression<T>(this.getNavigablePathCopy(lhsCopy), lhsCopy));
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(Class<S> treatJavaType) {
        throw new TreatException("Fk paths cannot be TREAT-ed");
    }

    @Override
    public <S extends T> SqmTreatedPath<T, S> treatAs(EntityDomainType<S> treatTarget) {
        throw new TreatException("Fk paths cannot be TREAT-ed");
    }

    @Override
    public SqmPath<?> resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        SqmPath sqmPath = this.get(name, true);
        creationState.getProcessingStateStack().getCurrent().getPathRegistry().register(sqmPath);
        return sqmPath;
    }
}

